% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ArArRedux.R
\name{weightedmean}
\alias{weightedmean}
\title{Calculate the weighted mean age}
\usage{
weightedmean(ages, prefix = NULL)
}
\arguments{
\item{ages}{an object of class \code{results}}

\item{prefix}{is either a string with the prefix of the
samples that need to be averaged, or a vector of sample names.}
}
\value{
a list with items:

\code{avgt}: the weighted mean age\cr
\code{err}: the standard error of \code{avgt}\cr
\code{MSWD}: the Mean Square of the Weighted Deviates
}
\description{
Computes the error weighted mean and MSWD of some samples taking
into covariances.
}
\examples{
data(Melbourne)
ages <- process(Melbourne$X,Melbourne$irr,Melbourne$fract)
weightedmean(ages,"MD2-1")
}

