% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EBV_functions.R
\name{breeding_values}
\alias{breeding_values}
\title{Simulating estimated breeding values}
\usage{
breeding_values(
  gen,
  batch = 0,
  TraitsIndex = c(1:Ntraits),
  Ntraits = BPdata$Ntraits,
  EBV,
  accuracy = NA,
  GenomLength,
  Ne,
  SizeTraining,
  h2 = BPdata$h2,
  presel_sibs = c(rep(1, times = length(TraitsIndex))),
  c2 = BPdata$c2,
  indexweights = c(1),
  a_var = BPdata$a_var,
  method_indexweights = 1
)
}
\arguments{
\item{gen}{The generation of the fish for which breeding values need to be simulated.}

\item{batch}{The batch of the fish for which breeding values need to be simulated, default is 0.}

\item{TraitsIndex}{A vector of traits that are in the index. For these traits, breeding values will be simulated.}

\item{Ntraits}{Total number of simulated traits. Does not need to be specified if a list called 'BPdata' including the variable Ntraits is available.}

\item{EBV}{A vector of methods for simulating EBVs for each trait in the selection index needs to be specified. Options: "pheno" for simulating an EBV that is equal to the phenotype of the trait; "GEBV" for simulating GEBVs as a value correlated to the true breeding value of the animal, this correlation equals the accuracy; "PEBV" for simulating EBVs as a value correlated to the true breeding value of the animal (correlation = accuracy) and the prediction errors are correlated to the common environmental effects; "sib_pheno" for simualting EBVs using only information of the sibs of the selection candidate. Accuracies can be specified in the parameter 'accuracy', or in the case of GEBVs, accuracies can be calculated with the formula of Deatwyler et al. (2010) when the effective population size, genome length and size of the trainingspopulation for each trait are specified.}

\item{accuracy}{Vector of accuracies with the length equal to the number of traits in the Index. For traits for which the accuracy is not needed or traits for which the accuracy needs to be calculated, NA needs to be specified in the vector.}

\item{GenomLength}{Genome length in Morgan.}

\item{Ne}{Effective population size.}

\item{SizeTraining}{Vector with the size of the training population for each trait in the index.}

\item{h2}{Vector with heritabilities. Does not need to be specified when the heritabilities are already provided in the list 'BPdata'.}

\item{presel_sibs}{Vector to indicate which preselected fish can be used to calculate the EBV when EBV = "sibs_pheno". Needs to be specified for each trait in index (if not applicable, then NA can be specified).}

\item{c2}{Vector with common environmental effects. Does not need to be specified when the common environmental effects are already provided in the list 'BPdata'.}

\item{indexweights}{If traits need to be combined in an index, then desired gain indices need to be specified for each trait in the index.}

\item{a_var}{Vector of genetic variances of all traits, does not need to be specified if already provided in the list 'BPdata'.}

\item{method_indexweights}{Either 1 or 2, default is 1, see Details.}
}
\value{
This function will change the data frame called 'ped'. Simulated breeding values will be added to the EBV columns and values will be added to the column 'Index'.
}
\description{
This function can be used to simulate estimated breeding values (EBV) for the selection candidates.
}
\details{
Breeding values will be simulated only for fish with ped$selcand == 1. EBVs are not estimated but simulated as a value correlated to the true breeding value. The correlation is equal to the accuracy, which can be calculated or provided by the user.

There are three options for simulating the EBVs, namely:\preformatted{- "pheno": EBV equal to phenotype.

- "PEBV": Pedigree estimated breeding values: either an accuracy needs to be provided or the accuracy will be calculated using information about the number of full sibs and half sibs present in the ped file. When the accuracy is calculated, it is assumed that the selection candidate has an own performance of the trait and that no common environmental effects are present (for example in group mating design). Only sibs that are also selection candidates are used in the calculation of the accuracy. When an accuracy is provided, prediction errors are correlated to the common environmental effects.

- "GEBV": Genomically estimated breeding values. Either an accuracy needs to be provided or the genome length, effective population size and size of the training population need to be provided in order to calculate the accuracy using the formula of Deatwyler et al. (2010).

- "sib_pheno": EBVs are calculated from the phenotypes of the full sibs and half sibs. If this option is choosen, then the parameter presel_sibs needs to be used to specify which sibs are going to be used to calculate the breeding values. For example, if presel_sibs = 2 is specified, then only the sibs that are preselected for 'environment 2' are used.
}

If EBVs are simulated for more than one trait, then the EBVs are combined in an index. Combining the traits in an index using the desired gains can be done in two ways:\preformatted{- Method 1 (default): For each trait, the desired gains are divided by the genetic standard deviations of the trait and then multipplied with the EBV. The index is a summation of these values of each trait.

- Method 2: The EBVs are first standardized to a mean of 100 and a standard deviation of 10 and then multiplied with the desired gains. The index is a summation of these values of each trait.
}
}
\examples{

\donttest{ped <- founderpopfam(Nm = 60,
                     Nf = 60,
                     Nm2 = 0,
                     Nf2 = 0,
                     Ntraits = 2,
                     TraitsIndex = 2,
                     Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                     Rcom = matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                     Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                     mean = c(50,500),
                     a_var = c(200,8000),
                     c_var = c(150,1000),
                     e_var = c(250,12000))
                     
Mating <- randommating(gen = 0,
                       Nfam_FS = 120)

for(fam in 1: nrow(Mating)){
ped <- offspringFSfam(gen = 1,
                      No = 100,
                      probmale = 0.5,
                      sire = Mating$Sire[fam],
                      dam = Mating$Dam[fam],
                      Ntraits = 2,
                      TraitsIndex = 2,
                      Rgen = matrix(c(1.00   , 0.48,
                                    0.48   , 1.00),
                                 nrow = 2),
                      Rcom = matrix(c(1.00  , 0.5,
                                    0.5   , 1.00),
                                 nrow = 2),
                      Rres = matrix(c(1.00   , 0.32,
                                    0.32   , 1.00),
                                 nrow = 2),
                      a_var = c(200,8000),
                      c_var = c(150,1000),
                      e_var= c(250,12000))
}

ped <- preselphen(gen = 1,
                  Nenv = 2,
                  Npresel = c(25,15),
                  trait = 1,
                  Ntraits = 2)
                  
ped <- avail_selection(gen = 1,
                       presel = 1,
                       surv = 0.9)
                       
ped <- breeding_values(gen = 1,
                       TraitsIndex = 2,
                       EBV = "GEBV",
                       GenomLength = 11.3,
                       Ne = 100,
                       SizeTraining = nrow(ped[ped$preselected ==2,]),
                       Ntraits = 2,
                       a_var = c(200,8000),
                       h2 = c(0.33,0.38))
}
}
