% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_distance_scatterplot.R
\name{Af_distance_scatterplot}
\alias{Af_distance_scatterplot}
\title{Function to scatterplot the distance to the germline to a numerical node feature of the AntibodyForests-object}
\usage{
Af_distance_scatterplot(
  AntibodyForests_object,
  node.features,
  distance,
  min.nodes,
  color.by,
  color.by.numeric,
  correlation,
  geom_smooth.method,
  color.palette,
  font.size,
  ylabel,
  point.size,
  output.file
)
}
\arguments{
\item{AntibodyForests_object}{AntibodyForests-object, output from Af_build()}

\item{node.features}{Node features in the AntibodyForests-object to compare (needs to be numerical)}

\item{distance}{\itemize{
\item string - How to calculate the distance to the germline.
'node.depth'     : The sum of edges on the shortest parth between germline and each node
'edge.length'    : The sum of edge length of the shortest path between germline and each node (Default)
}}

\item{min.nodes}{The minimum number of nodes for a tree to be included in this analysis (this included the germline). Default is 2.}

\item{color.by}{Color the scatterplot by a node.feature in the AntibodyForests-object, by the sample, or no color ("none). Default is "none".}

\item{color.by.numeric}{Logical. If TRUE, the color.by feature is treated as a numerical feature. Default is FALSE.}

\item{correlation}{"pearson", "spearman", "kendall", or "none"}

\item{geom_smooth.method}{"none", lm" or "loess". Default is "none".}

\item{color.palette}{The color palette to use for the scatterplot. Default for numerical color.by is "viridis".}

\item{font.size}{The font size of the plot. Default is 12.}

\item{ylabel}{The labels of the y-axis, in the same order as the node.features. Default is the node.features}

\item{point.size}{The size of the points in the scatterplot. Default is 1.}

\item{output.file}{string - specifies the path to the output file (PNG of PDF). Defaults to NULL.}
}
\value{
A ggplot2 object with the scatterplot
}
\description{
Function to scatterplot the distance to the germline to a numerical node feature of the AntibodyForests-object
}
\examples{
Af_distance_scatterplot(AntibodyForests_object = AntibodyForests::small_af,
                        node.features = "size",
                        distance = "edge.length",
                        min.nodes = 5,
                        color.by = "sample",
                        color.by.numeric = FALSE,
                        geom_smooth.method = "lm",
                        correlation = "pearson")
}
