% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Operations.R
\name{groupApply}
\alias{groupApply}
\title{Apply a function to groups of data in an Andromeda table}
\usage{
groupApply(
  tbl,
  groupVariable,
  fun,
  ...,
  batchSize = 1e+05,
  progressBar = FALSE,
  safe = FALSE
)
}
\arguments{
\item{tbl}{An \code{\link{Andromeda}} table (or any other 'DBI' table).}

\item{groupVariable}{The variable to group by}

\item{fun}{A function where the first argument is a data frame.}

\item{...}{Additional parameters passed to fun.}

\item{batchSize}{Number of rows fetched from the table at a time. This is not the number of
rows to which the function will be applied. Included mostly for testing
purposes.}

\item{progressBar}{Show a progress bar?}

\item{safe}{Create a copy of \code{tbl} first? Allows writing to the same Andromeda as being
read from.}
}
\value{
Invisibly returns a list of objects, where each object is the output of the user-supplied function
applied to a group.
}
\description{
Apply a function to groups of data in an Andromeda table
}
\details{
This function applies a function to groups of data. The groups are identified by unique values of
the \code{groupVariable}, which must be a variable in the table.
}
\examples{
andr <- andromeda(cars = cars)

fun <- function(x) {
  return(tibble::tibble(speed = x$speed[1], meanDist = mean(x$dist)))
}

result <- groupApply(andr$cars, "speed", fun)
result <- bind_rows(result)
result
# # A tibble: 19 x 2 
# speed meanDist 
# <dbl> <dbl> 
# 1 4 6 
# 2 7 13 
# 3 8 16 
# ...

close(andr)

}
\seealso{
\code{\link[=batchApply]{batchApply()}}
}
