% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Operations.R
\name{batchTest}
\alias{batchTest}
\title{Apply a boolean test to batches of data in an Andromeda table and terminate early}
\usage{
batchTest(tbl, fun, ..., batchSize = 1e+05)
}
\arguments{
\item{tbl}{An \code{\link{Andromeda}} table (or any other 'DBI' table).}

\item{fun}{A function where the first argument is a data frame and returns a logical value.}

\item{...}{Additional parameters passed to \code{fun}.}

\item{batchSize}{Number of rows to fetch at a time.}
}
\value{
Returns \code{FALSE} if any of the calls to the user-supplied function returned \code{FALSE}, else returns \code{TRUE}.
}
\description{
Apply a boolean test to batches of data in an Andromeda table and terminate early
}
\details{
This function applies a boolean test function to sets of
data and terminates at the first \code{FALSE}.
}
\examples{
andr <- andromeda(cars = cars)

fun <- function(x) {
  is.unsorted(x \%>\% select(speed) \%>\% collect())   
}

result <- batchTest(andr$cars, fun, batchSize = 25)

result
# [1] FALSE 

close(andr)

}
