% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/founderPop.R
\name{quickHaplo}
\alias{quickHaplo}
\title{Quick founder haplotype simulation}
\usage{
quickHaplo(nInd, nChr, segSites, genLen = 1, inbred = FALSE)
}
\arguments{
\item{nInd}{number of individuals to simulate}

\item{nChr}{number of chromosomes to simulate}

\item{segSites}{number of segregating sites per chromosome}

\item{genLen}{genetic length of chromosomes}

\item{inbred}{should founder individuals be inbred}
}
\value{
an object of \code{\link{MapPop-class}}
}
\description{
Rapidly simulates founder haplotypes by randomly 
sampling 0s and 1s. This is equivalent to having all loci with 
allele frequency 0.5 and being in linkage equilibrium.
}
\examples{
# Creates a populations of 10 outbred individuals
# Their genome consists of 1 chromosome and 100 segregating sites
founderPop = quickHaplo(nInd=10,nChr=1,segSites=100)

}
