% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{writePlink}
\alias{writePlink}
\title{Writes a Pop-class as PLINK files}
\usage{
writePlink(
  pop,
  baseName,
  trait = 1L,
  snpChip = 1L,
  simParam = NULL,
  chromLength = 10L^8
)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{baseName}{a character. Basename of PED and MAP files.}

\item{trait}{an integer. Which phenotype trait should be used.}

\item{snpChip}{an integer. Which SNP array should be used.}

\item{simParam}{an object of \code{\link{SimParam}}}

\item{chromLength}{an integer. The size of chromosomes in base
pairs; assuming all chromosomes are of the same size.}
}
\description{
Writes a Pop-class as PLINK PED and MAP files
}
\examples{
\dontrun{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$setGender(gender = "yes_rand")
SP$addTraitA(nQtlPerChr = 10)
SP$addSnpChip(nSnpPerChr = 5)

#Create population
pop = newPop(rawPop = founderPop)
pop = setPheno(pop, varE = SP$varA)
writePlink(pop, baseName="test")

#Test
test = read.table(file = "test.ped")
#...gender
if (!identical(x = c("M", "F")[test[[5]]], y = pop@gender)) { stop() }
#...pheno (issues with rounding)
# if (!identical(x = test[[6]], y = pop@pheno[, 1])) { stop() }
#...genotypes
x = test[, -(1:6)]  - 1
x[, 1] = x[, 1] + x[, 2]
x[, 2] = x[, 3] + x[, 4]
x[, 3] = x[, 5] + x[, 6]
x[, 4] = x[, 7] + x[, 8]
x[, 5] = x[, 9] + x[, 10]
y = pullSnpGeno(pop)
if (sum(x[, 1:5] - y) != 0) { stop() }
}
}
