% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popSummary.R
\name{aa}
\alias{aa}
\title{Additive-by-additive epistatic deviations}
\usage{
aa(pop, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\description{
Returns additive-by-additive epistatic 
deviations for all traits
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitAD(10, meanDD=0.5)
SP$setVarE(h2=0.5)

#Create population
pop = newPop(founderPop, simParam=SP)
aa(pop, simParam=SP)

}
