% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_filterDate.R
\name{sensor_filterDate}
\alias{sensor_filterDate}
\title{Date filtering for AirSensor objects}
\usage{
sensor_filterDate(
  sensor = NULL,
  startdate = NULL,
  enddate = NULL,
  days = NULL,
  weeks = NULL,
  timezone = "America/Los_Angeles"
)
}
\arguments{
\item{sensor}{An AirSensor object.}

\item{startdate}{Desired start datetime (ISO 8601).}

\item{enddate}{Desired end datetime (ISO 8601).}

\item{days}{Number of days to include in the filterDate interval.}

\item{weeks}{Number of weeks to include in the filterDate interval.}

\item{timezone}{Olson timezone used to interpret dates.}
}
\value{
A subset of the given \emph{sensor} object.
}
\description{
Subsets an AirSensor object by date. 

Dates can be anything that is understood by \code{lubrdiate::ymd()}
including either of the following recommended formats:

\itemize{
\item{\code{"YYYYmmdd"}}
\item{\code{"YYYY-mm-dd"}}
}
}
\examples{
library(AirSensor)

example_sensor \%>\% 
  sensor_extractData() \%>\%
  dplyr::pull("datetime") \%>\%
  range()
  
example_sensor \%>\% 
  sensor_filterDate(
    startdate = "2018-08-21", 
    enddate = "2018-08-28",
    timezone = "UTC"
  ) \%>\%
  sensor_extractData() \%>\%
  dplyr::pull("datetime") \%>\%
  range()
  
}
\seealso{
\link{sensor_filter}

\link{sensor_filterMeta}
}
