% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_replaceValues.R
\name{monitor_replaceValues}
\alias{monitor_replaceValues}
\title{Replace \emph{mts_monitor} data with another value}
\usage{
monitor_replaceValues(monitor = NULL, filter = NULL, value = NULL)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{filter}{R expression used to identify values for replacement.}

\item{value}{Numeric replacement value.}
}
\value{
A modified \code{mts_monitor} object. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
Use an R expression to identify values for replacement.

The R expression given in \code{filter} is used to identify elements
in \code{monitor$data} that should be replaced.  The \code{datetime} column
will be retained unmodified. Typical usage would include

\enumerate{
\item{replacing negative values with 0}
\item{replacing unreasonably high values with \code{NA}}
}

Expressions should use \code{data} for the left hand side of the comparison.
}
\examples{
library(AirMonitor)

wa <- monitor_filterMeta(NW_Megafires, stateCode == 'WA')
any(wa$data < 5, na.rm = TRUE)

wa_zero <- monitor_replaceValues(wa, data < 5, 5)
any(wa_zero$data < 5, na.rm = TRUE)
}
