% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_getCurrentStatus.R
\name{monitor_getCurrentStatus}
\alias{monitor_getCurrentStatus}
\title{Get current status of monitors}
\usage{
monitor_getCurrentStatus(
  monitor,
  enddate = NULL,
  minHours = 18,
  dayBoundary = c("clock", "LST")
)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{enddate}{Time relative to which current status is calculated. By
default, it is the latest time in \code{monitor$data$datetime}. This time can
be given as a POSIXct time, or a string/numeric value in ymd format (\emph{e.g.}
20190301). This time converted to UTC.}

\item{minHours}{Minimum number of valid hourly records required to calculate
\code{yesterday_PM2.5_avg}. Days with fewer valid records will be assigned \code{NA}.}

\item{dayBoundary}{Treatment of daylight savings time:  "clock" uses daylight
savings time as defined in the local timezone, "LST" uses "local standard time"
all year round. (See \code{monitor_dailyStatistic()} for more details.)}
}
\value{
The \code{monitor$meta} table augmented with current status
information for each time series.
}
\description{
This function augments \code{monitor$meta} with summary information derived
from \code{monitor$data} reflecting recent measurements.
}
\section{"Last" and "Previous"}{

The goal of this function is to provide useful information about what
happened recently with each time series in the provided \emph{mts_monitor} object.
Devices don't always consistently report data, however, and it is not alwlays
useful to have \code{NA}'s reported when there is recent valid data at earlier
times. To address this, \code{monitor_getCurrentStatus()} uses \emph{last} and
\emph{previous} valid times. These are the time when a monitor most recently
reported data, and the most recent time of valid data before that,
respectively. By reporting on these times, this function ensures that valid
data is returned and provides information on how outdated this information
is. This information can be used in maps to show AQI colored dots when data
is only a few hours old but gray dots when data is older than some threshold.
}

\section{Calculating latency}{

According to https://docs.airnowapi.org/docs/HourlyDataFactSheet.pdf
a datum assigned to 2pm represents the average of data between 2pm and 3pm.
So, if we check at 3:15pm and see that we have a value for 2pm but not 3pm
then the data are completely up-to-date with zero latency.

\code{monitor_getCurrentStatus()} defines latency as the difference between
a time index and the next most recent time index associated with a
valid value. If there is no more recent time index, then the difference is
measured to the given \code{enddate} parameter. Because \emph{mts_monitor}
objects are defined on an hourly axis, these differences have units of hours.

For example, if the recorded values for a monitor are
\code{[16.2, 15.8, 16.4, NA, 14.0, 12.5, NA, NA, 13.3, NA]}, then the \emph{last}
valid value is 13.3 with an index is 9, and the \emph{previous} valid value is 12.4
with an index of 6. The \emph{last} latency is then 1 (hour before the end), and the
\emph{previous} latency is 3 (hours before the last valid value).
}

\section{Summary data}{

The table created by \code{monitor_getCurrentStatus()} includes per-time series
summary information calculated from \code{monitor$data}.
The additional data fields added to \code{monitor$meta} are listed below:

\describe{
  \item{currentStatus_processingTime}{Time at which this function was run}
  \item{currentStatus_enddate}{Time relative to which "currency" is calculated}
  \item{last_validIndex}{Row index of the last valid mesurement in \code{monitor$data}}
  \item{previous_validIndex}{Row index of the previous valid measurement in \code{monitor$data}}
  \item{last_validTime}{UTC time associated with \code{last_validIndex}}
  \item{previous_validTime}{UTC time associated with \code{previous_validIndex}}
  \item{last_latency}{Hours between \code{last_validTime} and \code{endtime}}
  \item{previous_latency}{Hours between \code{previous_validTime} and\code{last_validTime}}
  \item{last_validLocalTimestamp}{Local time representation of \code{last_validTime}}
  \item{previous_validLocalTimestamp}{Local time representation of \code{previous_validTime}}
  \item{last_PM2.5}{Last valid PM2.5 measurement}
  \item{previous_PM2.5}{Previous valid PM2.5 measurement}
  \item{last_nowcast}{Last valid PM2.5 NowCast value}
  \item{previous_nowcast}{Previous valid PM2.5 NowCast value}
  \item{yesterday_PM2.5_avg}{Daily average PM2.5 for the day prior to \code{enddate}}
}
}

\examples{
\donttest{
# Fail gracefully if any resources are not available
try({

library(AirMonitor)

monitor <- airnow_loadLatest()
# TODO:  Needed before rebuilding of v2 database with fullAQSID
monitor$meta$fullAQSID <- paste0("840", monitor$meta$AQSID)

currentStatus <-
  monitor \%>\%
  monitor_filter(stateCode == "WA") \%>\%
  monitor_getCurrentStatus()

}, silent = FALSE)
}
}
