% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_filterDate.R
\name{monitor_filterDate}
\alias{monitor_filterDate}
\title{Date filtering for \emph{mts_monitor} objects}
\usage{
monitor_filterDate(
  monitor = NULL,
  startdate = NULL,
  enddate = NULL,
  timezone = NULL,
  unit = "sec",
  ceilingStart = FALSE,
  ceilingEnd = FALSE
)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{startdate}{Desired start datetime (ISO 8601).}

\item{enddate}{Desired end datetime (ISO 8601).}

\item{timezone}{Olson timezone used to interpret dates.}

\item{unit}{Units used to determine time at end-of-day.}

\item{ceilingStart}{Logical instruction to apply
\code{\link[lubridate]{ceiling_date}} to the \code{startdate} rather than
\code{\link[lubridate]{floor_date}}}

\item{ceilingEnd}{Logical instruction to apply
\code{\link[lubridate]{ceiling_date}} to the \code{enddate} rather than
\code{\link[lubridate]{floor_date}}}
}
\value{
A subset of the given \emph{mts_monitor} object. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
Subsets a \emph{mts_monitor} object by date. This function
always filters to day-boundaries. For sub-day filtering, use
\code{monitor_filterDatetime()}.

Dates can be anything that is understood by \code{MazamaCoreUtils::parseDatetime()}
including either of the following recommended formats:

\itemize{
\item{\code{"YYYYmmdd"}}
\item{\code{"YYYY-mm-dd"}}
}

If either \code{startdate} or \code{enddate} is not provided, the start/end of
the \emph{mts_monitor} time axis will be used.

Timezone determination precedence assumes that if you are passing in
\code{POSIXct} values then you know what you are doing.

\enumerate{
\item{get timezone from \code{startdate} if it is \code{POSIXct}}
\item{use passed in \code{timezone}}
\item{get timezone from \code{mts_monitor}}
}
}
\note{
The returned data will run from the beginning of \code{startdate} until
the \strong{beginning} of \code{enddate} -- \emph{i.e.} no values associated
with \code{enddate} will be returned. The exception being when
\code{enddate} is less than 24 hours after \code{startdate}. In that case, a
single day is returned.
}
\examples{
library(AirMonitor)

Camp_Fire \%>\%
  monitor_timeRange()

# Day boundaries returned in "UTC"
Camp_Fire \%>\%
  monitor_filterDate(
    "2018-11-15",
    "2018-11-22",
    timezone = "America/Los_Angeles"
  ) \%>\%
  monitor_timeRange()

# Day boundaries returned in "America/Los_Angeles"
Camp_Fire \%>\%
  monitor_filterDatetime(
    "20181115",
    "20181122",
    timezone = "America/Los_Angeles"
  ) \%>\%
  monitor_timeRange(
    timezone = "America/Los_Angeles"
  )

}
\seealso{
\link{monitor_filterDatetime}

\link{monitor_filterMeta}
}
