% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjdbc_function.R
\name{conjdbc}
\alias{conjdbc}
\title{Analysis: Joint analysis of experiments in randomized block design}
\usage{
conjdbc(
  trat,
  block,
  local,
  response,
  transf = 1,
  norm = "sw",
  homog = "bt",
  theme = theme_classic(),
  mcomp = "tukey",
  quali = TRUE,
  alpha.f = 0.05,
  alpha.t = 0.05,
  grau = NA,
  ylab = "response",
  title = "",
  xlab = "",
  fill = "lightblue",
  angulo = 0,
  textsize = 12,
  dec = 3,
  family = "sans",
  errorbar = TRUE
)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{block}{Numerical or complex vector with blocks}

\item{local}{Numeric or complex vector with locations or times}

\item{response}{Numerical vector containing the response of the experiment.}

\item{transf}{Applies data transformation (default is 1; for log consider 0)}

\item{norm}{Error normality test (\emph{default} is Shapiro-Wilk)}

\item{homog}{Homogeneity test of variances (\emph{default} is Bartlett)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{mcomp}{Multiple comparison test (Tukey (\emph{default}), LSD, Scott-Knott and Duncan)}

\item{quali}{Defines whether the factor is quantitative or qualitative (\emph{default} is qualitative)}

\item{alpha.f}{Level of significance of the F test (\emph{default} is 0.05)}

\item{alpha.t}{Significance level of the multiple comparison test (\emph{default} is 0.05)}

\item{grau}{Degree of polynomial in case of quantitative factor (\emph{default} is 1)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{title}{Graph title}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{fill}{Defines chart color (to generate different colors for different treatments, define fill = "trat")}

\item{angulo}{x-axis scale text rotation}

\item{textsize}{Font size}

\item{dec}{Number of cells}

\item{family}{Font family}

\item{errorbar}{Plot the standard deviation bar on the graph (In the case of a segment and column graph) - \emph{default} is TRUE}
}
\value{
Returns the assumptions of the analysis of variance, the assumption of the joint analysis by means of a QMres ratio matrix, the analysis of variance, the multiple comparison test or regression.
}
\description{
Function of the AgroR package for joint analysis of experiments conducted in a randomized qualitative or quantitative single-block design with balanced data.
}
\note{
The ordering of the graph is according to the sequence in which the factor levels are arranged in the data sheet. The bars of the column and segment graphs are standard deviation.

In the final output when transformation (transf argument) is different from 1, the columns resp and respo in the mean test are returned, indicating transformed and non-transformed mean, respectively.
}
\examples{
library(AgroR)
data(mirtilo)
with(mirtilo, conjdbc(trat, bloco, exp, resp))
}
\references{
Ferreira, P. V. Estatistica experimental aplicada a agronomia. Edufal, 2018.

Principles and procedures of statistics a biometrical approach Steel, Torry and Dickey. Third Edition 1997

Multiple comparisons theory and methods. Departament of statistics the Ohio State University. USA, 1996. Jason C. Hsu. Chapman Hall/CRC.

Practical Nonparametrics Statistics. W.J. Conover, 1999

Ramalho M.A.P., Ferreira D.F., Oliveira A.C. 2000. Experimentacao em Genetica e Melhoramento de Plantas. Editora UFLA.

Scott R.J., Knott M. 1974. A cluster analysis method for grouping mans in the analysis of variance. Biometrics, 30, 507-512.
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{Analysis}
\keyword{DBC}
\keyword{Joint}
