% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp_code_transform.R
\name{resp_code_transform}
\alias{resp_code_transform}
\title{Convert RECIST response code}
\usage{
resp_code_transform(
  data = NULL,
  response_col = NULL,
  new_col = response_col,
  key = c("1" = "Baseline (BL)", 
          "2" = "Not Evaluable (NE)",
          "3" = "Stable Disease (SD)",
          "4" = "Partial Response (PR)", 
          "5" = "Complete Response (CR)", 
          "6" = "Progressive Disease (PD)")
)
}
\arguments{
\item{data}{A dataframe object that includes the column of interest to convert.}

\item{response_col}{A string. The column name of the column to convert.}

\item{new_col}{A string. The new column name of the converted response column.
Defaults to original response column name.}

\item{key}{A named vector key on how to convert the response IDs.}
}
\value{
Dataframe.
}
\description{
Convert RECIST response code
}
\examples{
df <- data.frame(SampleID = c("A","B","C","D","E","F"),
Response = c("1","2","3","4","5","6"))
resp_code_transform(df,"Response", new_col = "Response_New")

}
