% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{last.plot.get.info}
\alias{last.plot.get.info}
\title{Access last adherence plot info.}
\usage{
last.plot.get.info()
}
\value{
A \code{list} (possibly empty) contaning one named element for each type
of plot produced (currently only \emph{baseR} and \emph{SVG}). Each may contain
shared and specific fields concerning:
\itemize{
 \item the values of the parameters with which \code{plot()} was invoked.
 \item actual plot size and other characteristics.
 \item actual title, axis names and labels and their position and size.
 \item legend size, position and size and position of its components.
 \item expanded \code{cma$data} contaning, for each event, info about its
 plotting, including the corresponding fullow-uo and observation windows,
 event start and end, dose text (if any) and other graphical elements.
 \item position, size of the partial CMAs (if any) and of their components.
 \item position, size of the plotted CMAs (if any) and of their components.
 \item rescaling function(s) useful for mapping events to plotting coordinates.
}
}
\description{
Returns the full info the last adherence plot, to be used to modify and/or to
add new elements to this plot.
}
\details{
This is intended for advanced users only.
It may return \code{NULL} if no plotting was generated yet, but if one was, a
list contaning one named element for each type of plot produced (currently only
\emph{baseR} and \emph{SVG} are used).
For all types of plots there are a set of \emph{mapping} functions useful for
transforming events in plotting coordinates: \code{.map.event.x(x)} takes a
number of days \code{x}, \code{.map.event.date(d, adjust.for.earliest.date=TRUE)}
takes a \code{Date} \code{d} (and implictely adjusts for the earilerst date
plotted), and  \code{.map.event.y(y)} takes a row ("event" number) \code{y}.
Besides the shared elements (see the returned value), there are specific ones
as well.
For \emph{baseR}, the members \emph{old.par} and \emph{used.par} contain the
original (pre-plot) \code{par()} environment and the one used within
\code{plot()}, respectively, in case these need restoring.
}
\examples{
cma7 <- CMA7(data=med.events[med.events$PATIENT_ID \%in\% c(1,2),],
             ID.colname="PATIENT_ID",
             event.date.colname="DATE",
             event.duration.colname="DURATION",
             event.daily.dose.colname="PERDAY",
             medication.class.colname="CATEGORY",
             followup.window.start=0,
             followup.window.start.unit="days",
             followup.window.duration=2*365,
             followup.window.duration.unit="days",
             observation.window.start=30,
             observation.window.start.unit="days",
             observation.window.duration=365,
             observation.window.duration.unit="days",
             date.format="\%m/\%d/\%Y",
             summary="Base CMA");
plot(cma7);
tmp <- last.plot.get.info();
names(tmp);
tmp$baseR$legend$box; # legend position and size
head(tmp$baseR$cma$data); # events + plotting info
# Add a transparent blue rect between days 270 and 900:
rect(tmp$baseR$.map.event.x(270), tmp$baseR$.map.event.y(1-0.5),
     tmp$baseR$.map.event.x(900), tmp$baseR$.map.event.y(nrow(tmp$baseR$cma$data)+0.5),
     col=adjustcolor("blue",alpha.f=0.5), border="blue");
# Add a transparent rect rect between dates 03/15/2036 and 03/15/2037:
rect(tmp$baseR$.map.event.date(as.Date("03/15/2036", format="\%m/\%d/\%Y")),
     tmp$baseR$.map.event.y(1-0.5),
     tmp$baseR$.map.event.date(as.Date("03/15/2037", format="\%m/\%d/\%Y")),
     tmp$baseR$.map.event.y(nrow(tmp$baseR$cma$data)+0.5),
     col=adjustcolor("red",alpha.f=0.5), border="blue");
}
