% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_elements.R
\name{.split_coord_fragments_in_BED}
\alias{.split_coord_fragments_in_BED}
\title{Splits a BED12 file into separate regions}
\usage{
.split_coord_fragments_in_BED(i, coords)
}
\arguments{
\item{i}{The i-th row of the coords data frame which needs to be split into separate elements}

\item{coords}{The coords data frame which is the imported BED12 file}
}
\value{
A data frame containing the following columns for a given BED12 identifier
\describe{
    \item{chr}{autosomal chromosomes as chr1 to chr22 and sex chromosomes as chrX and chrY}
    \item{start}{the start position of the element in base 0 coordinates (BED format)}
    \item{end}{the end position of the element in base 0 coordinates (BED format)}
    \item{id}{the element identifier - if the element contains multiple segments such as exons,
    each segment should be a separate row with the segment coordinates
    and the element identifier as id. Elements can be coding or noncoding such as exons of protein
    coding genes or active enhancers.}
}
}
\description{
Splits a BED12 file into separate regions
}
