% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_model.R
\name{best_model}
\alias{best_model}
\title{Create Best Model}
\usage{
best_model(model_data)
}
\arguments{
\item{model_data}{A data frame containing the model data.}
}
\value{
An object of class "best_model" containing the model data.
}
\description{
This function sets the class of the given model data to "best_model".
}
\examples{
# Generate sample model data
sample_model_data <- data.frame(
  ScYr = rep(1:3, each = 100),
  Date = rep(1:100, 3),
  Alarm = sample(c(0, 1), 300, replace = TRUE, prob = c(0.9, 0.1)),
  lag = sample(1:15, 300, replace = TRUE),
  thres = runif(300, 0.1, 0.6)
)

# Create best model
best_model_data <- best_model(sample_model_data)

# Print the class of the best model
class(best_model_data)
}
