% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATA_Forecast.R
\name{ATA.Forecast}
\alias{ATA.Forecast}
\title{Forecasting Method for The ATAforecasting}
\usage{
ATA.Forecast(
  object,
  h = NULL,
  out.sample = NULL,
  ci.level = 95,
  negative.forecast = TRUE
)
}
\arguments{
\item{object}{An \code{ATA} object is required for forecast.}

\item{h}{Number of periods for forecasting.}

\item{out.sample}{A numeric vector or time series of class \code{ts} or \code{msts} for out-sample.}

\item{ci.level}{Confidence Interval levels for forecasting. Default value is 95.}

\item{negative.forecast}{Negative values are allowed for forecasting. Default value is TRUE. If FALSE, all negative values for forecasting are set to 0.}
}
\value{
An object of class "\code{ATA}".
}
\description{
\code{ATA.Forecast} is a generic function for forecasting of the ATA Method.
}
\examples{
demoATA <- window(fundingTR, start = tsp(fundingTR)[1], end = 2013)
ata.fit <- ATA(demoATA, parPHI = 1, seasonal.test = TRUE, seasonal.model = "decomp")
ATA.plot(ATA.Forecast(ata.fit, h=18))


}
\references{
#'\insertRef{yapar2017mses}{ATAforecasting}

#'\insertRef{yapar2018mhes}{ATAforecasting}

#'\insertRef{yapar2018mses}{ATAforecasting}

#'\insertRef{yapar2019ata}{ATAforecasting}
}
\seealso{
\code{forecast}, \code{stlplus}, \code{stR}, \code{\link[stats]{stl}}, \code{\link[stats]{decompose}},
\code{tbats}, \code{seasadj}.
}
\author{
Ali Sabri Taylan and Hanife Taylan Selamlar
}
\keyword{Ata}
\keyword{accuracy}
\keyword{forecast}
\keyword{msts}
\keyword{ts}
