% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gvmi.R
\name{gvmi}
\alias{gvmi}
\title{Global Vegetation Moisture Index}
\usage{
gvmi(directory = getwd(), crop = "n", ext2crop = "none")
}
\arguments{
\item{ext2crop, crop, directory}{Same as mentioned in \code{\link[ASIP]{arvi}}.}
}
\value{
File named gvmi_'date of satellite image acqisition'.tif in the input folder
}
\description{
Global Vegetation Moisture Index (GVMI) is suitable for retrieving vegetation water content
when the LAI is equal to or greater than 2. For sparsely
vegetated area, where LAI is less than 2, further research is
required to understand the role of soil effects on reflectance
measured in the all-optical spectrum (Ceccato et, al. 2002).
}
\note{
1. GVMI = ((r_nir + 0.1)- (r_swir2+0.2))/ ((r_nir + 0.1)- (r_swir2+0.2))

where, "r_" denotes TOA reflectance band.
Other important notes are mentioned in \code{\link[ASIP]{custom.eqn}}.
}
\examples{
library (raster)
library (rgdal)
# Finding the path of the sample satellite image directory.
# User may define paths directly like "/home/ur_folder" or "C:/ur_folder"
path <- system.file ("TM_sample", package = "ASIP")
shapefil <- paste0 (path, "/test.shp")
gvmi (directory = path, crop = "y", ext2crop = shapefil)
}
\references{
\href{http://www.sciencedirect.com/science/article/pii/S0034425702000378}{Ceccato P, Gobron N, Flasse S, Pinty B and Tarantola S (2002) Designing a spectral index to estimate vegetation water content from remote sensing data: Part 1: Theoretical approach. Remote Sensing of Environment, 82(2-3), pp:188-197. doi:10.1016/S0034-4257(02)00037-8.}
}
