% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ElkinABC}
\alias{ElkinABC}
\title{Synthetic 2x2x2 Within-Subjects Experiment}
\format{
A data frame with 64 observations on the following 5 variables.
\describe{
     \item{S}{a factor representing subjects with levels \code{"s1"} .. \code{"s8"}}
     \item{A}{a factor with levels \code{"a1"} \code{"a2"}}
     \item{B}{a factor with levels \code{"b1"} \code{"b2"}}
     \item{C}{a factor with levels \code{"c1"} \code{"c2"}}
     \item{Y}{a numeric vector}
}
}
\source{
Elkin, L. A., Kay, M, Higgins, J. J., and Wobbrock, J. O.
  (2021). An aligned rank transform procedure for multifactor contrast tests.
  \emph{Proceedings of the ACM Symposium on User Interface Software and
  Technology (UIST '21)}. Virtual Event (October 10--14, 2021). New York:
  ACM Press, pp. 754--768. \doi{10.1145/3472749.3474784}
}
\description{
Synthetic data from an experiment with three within-subjects factors
(\code{A}, \code{B}, and \code{C}) having two levels each.
}
\examples{
\donttest{
data(ElkinABC, package = "ARTool")

## run contrast using the ART-C procedure on the data.
m <- art(Y ~ A*B*C + (1|S), data = ElkinABC)
art.con(m, "A:B:C")
}
}
\keyword{datasets}
