% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my_own_banner.R
\name{my_own_banner}
\alias{my_own_banner}
\alias{fold_it}
\title{Core functions for comment making}
\usage{
my_own_banner(
  x,
  ...,
  emph = FALSE,
  snug = FALSE,
  upper = emph,
  centre = !fold,
  leftSideHashes = 2 + emph,
  rightSideHashes = leftSideHashes,
  minHashes = (!snug) * (80 + 10 * emph),
  numLines = 1 + emph,
  bandChar = "#",
  center = centre,
  fold = FALSE,
  maxChar = 75
)

fold_it(x, maxChar, exdent = 0)
}
\arguments{
\item{x}{the string}

\item{...}{Zero or more additional strings as extra lines.  Strings may contain
newline characters resulting in further line breaks.}

\item{emph}{A logical value: Do you want this to be an emphasised comment?}

\item{snug}{A logical value: Do you want the decoration to hug the strings closely?}

\item{upper}{A logical value: Do you want the strings converted to upper case?}

\item{centre}{A logical value: Do you want the text strings centred?
(alternative: left justified)}

\item{leftSideHashes}{A positive integer: How many hashes go on the left side?}

\item{rightSideHashes}{A non-negative integer: How many hashes go on the right side?}

\item{minHashes}{A non-negative integer: What is the minimum number of hashes
in the boundary lines?}

\item{numLines}{A non-negative integer: How many lines of hashes above
and below do you want?}

\item{bandChar}{A single character.  Used instead of # for all characters in
the bands around the text, apart from the first character of every line.}

\item{center}{Alternative spelling of \code{centre}.}

\item{fold}{Logical: should the text be folded to ensure lines are not too long?}

\item{maxChar}{same as width in str_wrap}

\item{exdent}{for xxx_list()}
}
\value{
A character string vector returned invisibly,
but automatically displayed in the console


}
\description{
This is modified from \code{bannerCommenter::banner()}, the main modification is to extend the comment length (minHashes) to 80
}
\section{Functions}{
\itemize{
\item \code{fold_it}: sub-function to fold sentence, don't use this in other circumstance
}}

\examples{
my_own_banner("This should appear clearly and stand out.",
       "The lines are left justified by default.")
##This is NOT recommended!!!
##This is NOT recommended!!!
##This is NOT recommended!!!
##pls use bannerCommenter::banner()
}
