% Generated by roxygen2 (4.0.1): do not edit by hand
\name{interval_recording}
\alias{interval_recording}
\title{Applies interval recording to a behavior stream}
\usage{
interval_recording(BS, interval_length, rest_length = 0, partial = TRUE,
  summarize = TRUE)
}
\arguments{
\item{BS}{object of class behavior_stream}

\item{interval_length}{time length of each interval.}

\item{rest_length}{portion of each interval to exclude from observation. Default is zero. See details.}

\item{partial}{logical value indicating whether to use partial interval recording (\code{TRUE}) or
whole interval recording (\code{FALSE}).}

\item{summarize}{logical value indicating whether vector of moments should be summarized by taking their mean.}
}
\value{
If \code{summarize = FALSE}, a matrix with rows equal to the number of intervals per session and
columns equal to the number of behavior streams in \code{BS}.
If \code{summarize = TRUE}, a vector of proportions of length equal to the
number of behavior streams in \code{BS}.
}
\description{
Divides the observation session into a specified number of intervals. For partial interval recording,
each interval is scored according to whether the behavior is present at any point during the interval. For whole
interval recording, each interval is scored according to whether the behavior is present for the duration.
}
\details{
Each behavior stream is divided into intervals of length \code{interval_length}.
The last \code{rest_length} of each interval is excluded from observation.
For example, for a stream length of 100, \code{interval_length = 20}, and
\code{rest_length = 5}, the first interval runs from [0,15), the second interval runs from [20,35), etc.
}
\examples{
BS <- r_behavior_stream(n = 5, mu = 3, lambda = 10,
                       F_event = F_exp(), F_interim = F_exp(), stream_length = 100)
interval_recording(BS, interval_length = 20, partial = TRUE, summarize = FALSE)
interval_recording(BS, interval_length = 20, partial = TRUE, summarize = TRUE)
colMeans(interval_recording(BS, 20, partial = TRUE, summarize = FALSE))
interval_recording(BS, interval_length = 20, rest_length = 5, partial = FALSE)
}

