% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argos_files.R
\name{duffing_oscillator}
\alias{duffing_oscillator}
\title{Duffing Oscillator}
\usage{
duffing_oscillator(
  n,
  dt,
  init_conditions,
  gamma_value,
  kappa_value,
  epsilon_value,
  snr = Inf
)
}
\arguments{
\item{n}{Number of time points (rounded to the nearest integer).}

\item{dt}{Time step between observations.}

\item{init_conditions}{Initial conditions as a numeric vector of length 2.}

\item{gamma_value}{Value of gamma parameter.}

\item{kappa_value}{Value of kappa parameter.}

\item{epsilon_value}{Value of epsilon parameter.}

\item{snr}{Signal-to-noise ratio (in dB). Use Inf for no noise.}
}
\value{
A numeric matrix representing the system's state over time. Each row
        corresponds to a time point, and each column represents a variable.
}
\description{
Simulates the Duffing oscillator with optional noise.
}
\details{
This function simulates a Duffing oscillator with the specified parameters.
It uses the specified time step and initial conditions to compute the system's
state over time. If a non-Infinite SNR is provided, Gaussian noise is added to
the system.
}
\examples{
# Simulate a Duffing oscillator with 100 time points and no noise
data <- duffing_oscillator(
  n = 100,
  dt = 0.01,
  init_conditions = c(2, 6),
  gamma_value = 0.1,
  kappa_value = 1,
  epsilon_value = 5,
  snr = Inf
)

}
