% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.affinity.R
\name{met.affinity}
\alias{met.affinity}
\title{Affinity}
\usage{
met.affinity(M, df = NULL, dfid = NULL, binary = FALSE)
}
\arguments{
\item{M}{a square adjacency matrix, or a list of square adjacency matrices, or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{df}{a data frame of same length as the input matrix or a list of data frames if argument \emph{M} is a list of matrices or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{dfid}{an integer or a string indicating the column with individual ids in argument \emph{df}.}

\item{binary}{a boolean, if \emph{TRUE}, it calculates the binary version of the affinity.}
}
\value{
\itemize{
\item An integer vector of nodes \emph{affinity} if argument \emph{df} is \emph{NULL}.
\item A list of integer vectors of nodes \emph{affinity} if argument \emph{M} is a list of matrices and  if argument \emph{df} is \emph{NULL}.
\item A list of arguments df with a new column for nodes \emph{affinity} if argument\emph{df} is not \emph{NULL}. The name of the column is adapted according to argument value \emph{binary}.
\item A list of arguments df with a new column for nodes \emph{affinity} if 1) argument \emph{df} is not \emph{NULL}, 2) argument \emph{M} is an output from ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk} for multiple matrices permutations, and 3) argument \emph{df} is a list of data frames of same length as argument \emph{M}.The names of the column of each element of the list is adapted according to argument value \emph{binary}.
}
}
\description{
Calculates the node metric \emph{affinity} for all the nodes of the network
}
\details{
Affinity is a second-order metric that evaluates how alters of node i are connected.
The binary version is the average degree of alters of node i.
The weighted version is the ratio between the metric reach and the strength of node i. A high affinity reveals that nodes tend to be connected to alters with high degrees or strengths.
Thus, this metric informs on node assortativity by vertex met.degree, i.e. connections between nodes with similar degrees or strengths.
}
\examples{
met.affinity(sim.m)
head(sim.df)
met.affinity(sim.m,df=sim.df)
}
\references{
Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
