% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.glmm.no.first.model.R
\name{stat.glmm.no.first.model}
\alias{stat.glmm.no.first.model}
\title{Extracts statistical measures of interest in Generalized Linear Mixed Models}
\usage{
stat.glmm.no.first.model(
  ant,
  formula,
  family,
  oda = NULL,
  progress = TRUE,
  odf,
  ...
)
}
\arguments{
\item{ant}{an output of ANT function \code{perm.net.nl} with random factor stated, or output of ANT 'met' categories functions in which output of ANT functions \code{perm.ds.focal}, \code{perm.ds.grp} or \code{perm.net.lk} where multiple matrices have been used.}

\item{formula}{two-sided linear formula object describing both the fixed-effects and random-effects part of the model, with the response on the left of a ~ operator and the terms, separated by + operators, on the right. Random-effects terms are distinguished by vertical bars (|) separating expressions for design matrices from grouping factors. Two vertical bars (||) can be used to specify multiple uncorrelated random effects for the same grouping variable. (Because of the way it is implemented, the ||-syntax works only for design matrices containing numeric (continuous) predictors; to fit models with independent categorical effects, see dummy or the lmer_alt function from the afex package.).}

\item{family}{a GLM family, see \code{\link{glm}} and \code{\link{family}}.}

\item{oda}{the original data frame of associations when argument ant is obtained with perm.ds.grp or perm.ds.focal ANT functions.}

\item{progress}{a boolean indicating the visualization of the permutation process.}

\item{odf}{the original data frame}

\item{...}{Extra arguments for \code{lmer} or \code{glmer} function only.}
}
\value{
Returns a list of 3 elements :
\itemize{
\item An object of class \code{\link{merMod}} (more specifically, an object of subclass lmerMod or glmerMod), for which many methods are available (e.g. methods(class="merMod")).
\item A data frame if the estimates of the permuted models.
\item A vector of integers indicating the permutations that returned model errors or warnings (e.g. model convergence issues) and for which new permutations were done.
}
}
\description{
Performs Generalized Linear Mixed Models tests
}
\details{
GLMM with permutation data.
}
\seealso{
\code{\link{lmer}} or \code{\link{glmer}}
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
