% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOFA-power.R
\name{anofaN2Power}
\alias{anofaN2Power}
\alias{anofaPower2N}
\title{Computing power within the ANOFA.}
\usage{
anofaPower2N(power, P, f2, alpha)

anofaN2Power(N, P, f2, alpha)
}
\arguments{
\item{N}{sample size;}

\item{P}{number of groups;}

\item{f2}{effect size Cohen's $f^2$;}

\item{alpha}{(default if omitted .05) the decision threshold.}

\item{power}{target power to attain;}
}
\value{
a model fit to the given frequencies. The model must always be an omnibus model
(for decomposition of the main model, follow the analysis with \code{emfrequencies()} or \code{contrasts()})
}
\description{
The function \code{anofaN2Power()} performs an analysis of statistical power
according to the \code{ANOFA} framework. See \insertCite{lc23b}{ANOFA} for more.
\code{anofaPower2N()} computes the sample size to reach a given power.
}
\examples{
# 1- The Landis et al. study had tremendous power with 533 participants in 15 cells:
# where 0.2671 is the observed effect size for the interaction.
anofaN2Power(533, 5*3, 0.2671)
# power is 100\% because sample is large and effect size is as well.

# Even with a quarter of the participants, power is overwhelming:
# because the effect size is quite large.
anofaN2Power(533/4, 5*3, 0.2671)

# 2- Power planning.
# Suppose we plan a four-classification design with expected frequencies of:
pred <- c(.35, .25, .25, .15)
# P is the number of classes (here 4)
P <- length(pred)
# We compute the predicted f2 as per Eq. 5
f2 <- 2 * sum(pred * log(P * pred) )
# the result, 0.0822, is a moderate effect size.

# Finally, aiming for a power of 80\%, we run
anofaPower2N(0.80, P, f2)
# to find that a little more than 132 participants are enough.


}
\references{
\insertAllCited{}
}
