% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/like.R
\name{like}
\alias{like}
\alias{\%like\%}
\alias{\%like_case\%}
\title{Pattern Matching}
\source{
Idea from the \href{https://github.com/Rdatatable/data.table/blob/master/R/like.R}{\code{like} function from the \code{data.table} package}, but made it case insensitive at default and let it support multiple patterns. Also, if the regex fails the first time, it tries again with \code{perl = TRUE}.
}
\usage{
like(x, pattern, ignore.case = TRUE)

x \%like\% pattern

x \%like_case\% pattern
}
\arguments{
\item{x}{a character vector where matches are sought, or an object which can be coerced by \code{\link[=as.character]{as.character()}} to a character vector.}

\item{pattern}{a character string containing a regular expression (or \code{\link{character}} string for \code{fixed = TRUE}) to be matched in the given character vector. Coerced by \code{\link[=as.character]{as.character()}} to a character string if possible.  If a \code{\link{character}} vector of length 2 or more is supplied, the first element is used with a warning.}

\item{ignore.case}{if \code{FALSE}, the pattern matching is \emph{case sensitive} and if \code{TRUE}, case is ignored during matching.}
}
\value{
A \code{\link{logical}} vector
}
\description{
Convenient wrapper around \code{\link[base:grep]{base::grep()}} to match a pattern: \code{a \%like\% b}. It always returns a \code{\link{logical}} vector and is always case-insensitive (use \code{a \%like_case\% b} for case-sensitive matching). Also, \code{pattern} (\emph{b}) can be as long as \code{x} (\emph{a}) to compare items of each index in both vectors, or can both have the same length to iterate over all cases.
}
\details{
Using RStudio? This function can also be inserted from the Addins menu and can have its own Keyboard Shortcut like \code{Ctrl+Shift+L} or \code{Cmd+Shift+L} (see \code{Tools} > \verb{Modify Keyboard Shortcuts...}).
}
\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
# simple test
a <- "This is a test"
b <- "TEST"
a \%like\% b
#> TRUE
b \%like\% a
#> FALSE

# also supports multiple patterns, length must be equal to x
a <- c("Test case", "Something different", "Yet another thing")
b <- c("case", "diff", "yet")
a \%like\% b
#> TRUE TRUE TRUE

# get frequencies of bacteria whose name start with 'Ent' or 'ent'
library(dplyr)
example_isolates \%>\%
  filter(mo_genus(mo) \%like\% '^ent') \%>\%
  freq(mo_fullname(mo))
}
\seealso{
\code{\link[base:grep]{base::grep()}}
}
