% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ab_property.R
\name{ab_property}
\alias{ab_property}
\alias{ab_name}
\alias{ab_atc}
\alias{ab_cid}
\alias{ab_synonyms}
\alias{ab_tradenames}
\alias{ab_group}
\alias{ab_atc_group1}
\alias{ab_atc_group2}
\alias{ab_ddd}
\alias{ab_info}
\title{Property of an antibiotic}
\usage{
ab_name(x, language = get_locale(), tolower = FALSE, ...)

ab_atc(x, ...)

ab_cid(x, ...)

ab_synonyms(x, ...)

ab_tradenames(x, ...)

ab_group(x, language = get_locale(), ...)

ab_atc_group1(x, language = get_locale(), ...)

ab_atc_group2(x, language = get_locale(), ...)

ab_ddd(x, administration = "oral", units = FALSE, ...)

ab_info(x, language = get_locale(), ...)

ab_property(x, property = "name", language = get_locale(), ...)
}
\arguments{
\item{x}{any (vector of) text that can be coerced to a valid microorganism code with \code{\link{as.ab}}}

\item{language}{language of the returned text, defaults to system language (see \code{\link{get_locale}}) and can also be set with \code{\link{getOption}("AMR_locale")}. Use \code{language = NULL} or \code{language = ""} to prevent translation.}

\item{tolower}{logical to indicate whether the first character of every output should be transformed to a lower case character. This will lead to e.g. "polymyxin B" and not "polymyxin b".}

\item{...}{other parameters passed on to \code{\link{as.ab}}}

\item{administration}{way of administration, either \code{"oral"} or \code{"iv"}}

\item{units}{a logical to indicate whether the units instead of the DDDs itself must be returned, see Examples}

\item{property}{one of the column names of one of the \code{\link{antibiotics}} data set}
}
\value{
\itemize{
  \item{An \code{integer} in case of \code{ab_cid}}
  \item{A named \code{list} in case of \code{ab_info} and multiple \code{ab_synonyms}/\code{ab_tradenames}}
  \item{A \code{double} in case of \code{ab_ddd}}
  \item{A \code{character} in all other cases}
}
}
\description{
Use these functions to return a specific property of an antibiotic from the \code{\link{antibiotics}} data set. All input values will be evaluated internally with \code{\link{as.ab}}.
}
\details{
All output will be \link{translate}d where possible.
}
\section{Source}{

World Health Organization (WHO) Collaborating Centre for Drug Statistics Methodology: \url{https://www.whocc.no/atc_ddd_index/}

WHONET 2019 software: \url{http://www.whonet.org/software.html}

European Commission Public Health PHARMACEUTICALS - COMMUNITY REGISTER: \url{http://ec.europa.eu/health/documents/community-register/html/atc.htm}
}

\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
# all properties:
ab_name("AMX")       # "Amoxicillin"
ab_atc("AMX")        # J01CA04 (ATC code from the WHO)
ab_cid("AMX")        # 33613 (Compound ID from PubChem)

ab_synonyms("AMX")   # a list with brand names of amoxicillin
ab_tradenames("AMX") # same

ab_group("AMX")      # "Beta-lactams/penicillins"
ab_atc_group1("AMX") # "Beta-lactam antibacterials, penicillins"
ab_atc_group2("AMX") # "Penicillins with extended spectrum"

ab_name(x = c("AMC", "PLB"))  # "Amoxicillin/clavulanic acid" "Polymyxin B"
ab_name(x = c("AMC", "PLB"),
        tolower = TRUE)       # "amoxicillin/clavulanic acid" "polymyxin B"

ab_ddd("AMX", "oral")               #  1
ab_ddd("AMX", "oral", units = TRUE) # "g"
ab_ddd("AMX", "iv")                 #  1
ab_ddd("AMX", "iv", units = TRUE)   # "g"

ab_info("AMX")       # all properties as a list

# all ab_* functions use as.ab() internally:
ab_name("Fluclox")   # "Flucloxacillin"
ab_name("fluklox")   # "Flucloxacillin"
ab_name("floxapen")  # "Flucloxacillin"
ab_name(21319)       # "Flucloxacillin" (using CID)
ab_name("J01CF05")   # "Flucloxacillin" (using ATC)
}
\seealso{
\code{\link{antibiotics}}
}
