% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FillNA.R
\docType{methods}
\name{fillNA}
\alias{fillNA}
\title{Fill missing values (NA) with averaged neighboring data}
\usage{
fillNA(
  vxsp,
  variable.name,
  variable.min = -Inf,
  variable.max = Inf,
  variable.fallback,
  radius,
  pulse.min = 10
)
}
\arguments{
\item{vxsp}{a \code{\linkS4class{VoxelSpace}} object.}

\item{variable.name}{a character, the name of a variable in the VoxelSpace}

\item{variable.min}{a numeric, minimal value for the fill values}

\item{variable.max}{a numeric, maximal value for the fill values}

\item{variable.fallback}{a numeric, optional fallback value in case no fill
value can be estimated from neighboring voxels.}

\item{radius}{a numeric, the radius in meter that defines the neighborhood of
a voxel. The function looks for the voxels whose center is inside a sphere
of radius \code{radius} centered at current voxel center. Default is set to
\code{max(getVoxelSize(vxsp))}}

\item{pulse.min}{a numeric, minimal sampling intensity (i.e. number of pulses
that went through a voxel) to include neighboring voxel in the estimation of
the averaged fill value.}
}
\description{
Fill missing values of a given variable in a VoxelSpace object
with averaged neighboring values.

Neighboring values are selected among voxels within a user-defined radius
in meter and whose sampling rate (number of pulses that went through the
voxel) is above a user-defined threshold. Distance between voxels is the
euclidian distance between voxel centers. Fill-value may be capped by
user-defined minimal and maximal values.

Default radius (if not defined by user) is set to largest dimension of voxel
size \code{max(getVoxelSize(vxsp))}. It guarantees that default neighborhood is
isotropic.

In some cases, for instance poorly sampled area, neighboring values may all
be missing or discarded. A fallback value can be provided to "force fill"
suche voxels. An other option is to run again the function with larger
radius or lower sampling threshold.
}
\examples{
# read voxel space
vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))
# Randomly add some NA in PAD variable
vx <- vxsp@data
ind <- sample(vx[PadBVTotal > 0, which = TRUE], 3)
# print initial values
vx[ind, .(i, j, k, PadBVTotal)]
vx[ind, PadBVTotal := NA]
# fill NA in PAD variable
fillNA(vxsp, "PadBVTotal", variable.max = 5)
# print filled values
vx[ind, .(i, j, k, PadBVTotal)]

}
