% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_names.R
\name{search_names}
\alias{search_names}
\title{Lookup of taxonomic names}
\usage{
search_names(taxa = c(), vernacular = FALSE, guids_only = FALSE,
  occurrence_count = FALSE, output_format = "simple")
}
\arguments{
\item{taxa}{string: a single name or vector of names}

\item{vernacular}{logical: if TRUE, match on common names as well as scientific names, otherwise match only on scientific names}

\item{guids_only}{logical: if TRUE, a named list of GUIDs will be returned. Otherwise, a data frame with more comprehensive information for each name will be returned.}

\item{occurrence_count}{logical: if TRUE (and if \code{guids_only} is FALSE) then also return the number of occurrences of each matched name.
Note that this requires one extra web call for each name, and so may be slow. Only applicable if \code{guids_only} is FALSE.}

\item{output_format}{string: controls the print method for the returned object (only has an effect when \code{guids_only} is FALSE). Either "complete" (the complete data structure is displayed), or "simple" (a simplified version is displayed). Note that the complete data structure exists in both cases: this option only controls what is displayed when the object is printed to the console. The default output format is "simple"}
}
\value{
A data frame of results, or named list of GUIDs if \code{guids_only} is TRUE. The results should include one entry (i.e. one data.frame row or one list element) per input name. The columns in the data.frame output may vary depending on the results returned by the ALA server, but should include searchTerm, name, rank, and guid.
}
\description{
Provides GUID, taxonomic classification, and other information for a list of names. 
Case-insensitive but otherwise exact matches are used.
}
\examples{
\dontrun{
search_names(c("Grevillea humilis", "Grevillea humilis subsp. maritima",
  "Heleioporus", "Thisisnot aname"))

search_names(c("Grevillea humilis", "Grevillea humilis subsp. maritima",
  "Heleioporus", "Thisisnot aname"), guids_only=TRUE)

search_names("kookaburra", vernacular=FALSE)

search_names("kookaburra", vernacular=TRUE)

## occurrence counts for matched names
search_names(c("Grevillea humilis", "Grevillea humilis subsp. maritima",
  "Heleioporus", "Thisisnot aname"), occurrence_count=TRUE)

## no occurrence counts because guids_only is TRUE
search_names(c("Grevillea humilis", "Grevillea humilis subsp. maritima",
  "Heleioporus", "Thisisnot aname"), occurrence_count=TRUE, guids_only=TRUE)
}
}
\references{
The associated ALA web service: \url{https://api.ala.org.au/#ws87}
}
