\name{dp.interp}
\alias{dp.interp}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Areal interpolation using precalculated weights}
\description{
  Given areal weights such as those returned by \code{arealw} or \code{mult.arealw}, calculates the approximate value enclosed in target polygons, as well as extremely conservative bounds on the estimates generated.  At present makes the estimate makes the strong assumption that data of interest is uniformly distributed within the zonal polygons.  The bounds assume the most pathological distribution, as appropriate.   
}
\usage{
dp.interp(wtmat, recvar = 1, recvals = bgvals, appdam = FALSE, 
  trimmedin = FALSE, nobounds = FALSE, dr = damrats)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{wtmat}{A matrix or vector containing at least areal weights.  Accepts several forms of input. See \code{Details.}}
  \item{recvar}{An integer indicating which column of the record value matrix to use. That is, what variable is to be interpolated.}
  \item{recvals}{A matrix containing the data to be interpolated, with rows corresponding to zones, and columns corresponding to different variables.}
  \item{appdam}{CA Wildfire specific.  A logical indicating whether or not to apply the empirically derived damage ratio.}
  \item{trimmedin}{A logical indicating whether or not \code{wtmat} was generated using the \code{trimout} option of \code{arealw} or \code{mult.arealw}.  If so, it should be a two column matrix indicating non-zero zones and their weights.  See the \code{arealw} help for details.} 
  \item{nobounds}{Logical indicating whether or not to return the estimates without bounds. Default is \sQuote{FALSE}, but there may be situations where having nobounds will be more convenient for handling data objects.  See \code{Details} for how the bounds are generated.}
  \item{dr}{CA Wildfire specific.  A vector giving precalculated damage ratios by block group.}
}

\details{
  The input may be of several forms:  Either a matrix such as that outputted by \code{arealw} when called with \code{trimout=TRUE}, or a vector of weights for one target polygon (the output of \code{arealw} with \code{trimout=FALSE}), or as a matrix, each column of which is a vector of weights for one target polygon (the output of \code{mult.arealw} with \code{trimout=FALSE}).     
  
The lower bound estimate is generated by assuming any zone less than fully enclosed by the target polygon contributes zero to the total value contained.  The upper bound is generated by  assuming that any zone with nonzero overlap contributes its entire value.  In all cases, zones that are entirely enclosed contribute their entire value.   
}

\value{The most common output will be an \sQuote{n} by 3 matrix, though either a vector or matrix can be returned, depending on the arguments passed:

If passed weights for target polygons with \code{nobounds=TRUE}, the results will be a vector listing the estimate for each polygon.

Lastly, if \code{nobounds=FALSE} (the default), the result is an \sQuote{n} by 3 matrix, with \sQuote{n} equal to the number of target polygons.  The columns correspond to expected value, lower bound and upper bound respectively.  

Note that if the weights are passed in trimmed form (using \code{trimmedin=TRUE}), then only values for one polygon can be calculated.  To quickly calculate for multiple polygons, simply run \code{lapply} on a list of polygon weights, such as that returned by \code{mult.arealw.} 
}
\references{Westerling, A. L. and B. P. Bryant, 2008. Climate Change and Wildfire in California. Climatic Change, 87: s231-249.}
\author{Benjamin P. Bryant, \email{bryant@prgs.edu}, and Anthony Westerling, \email{awesterling@ucmerced.edu}}
\note{The bounds on the outputs when \code{appdam} is set to \code{TRUE} do not take into account uncertainty in the damage ratio.  The absolute high would be to take the upper bound when not applying the damage ratio, and the absolute low is always zero.}  
%\note{ ~~further notes~~ 
%
% ~Make other sections like Warning with \section{Warning }{....} ~
%}
\seealso{\code{\link{arealw}}, \code{\link{mult.arealw}}}
\examples{

data(bgvals)
data(cabgbbmat)
data(cabggpc)
data(damrats)
data(fpdemogpc)
data(rbgarea)
data(polytobg)

#Get areal weights in various forms:

fire1 <- arealw(fpdemogpc[[1]],trimout=TRUE)  #single trimmed matrix
fire3 <- arealw(fpdemogpc[[3]],trimout=FALSE) #single untrimmed vector

#length 2 list of trimmed matrices.
both <- mult.arealw(target.ind=c(1,3), targetlist = fpdemogpc, trimout=TRUE)

#n by 2 matrix of cbound vectors:
bothfat <- mult.arealw(target.ind=c(1,3),targetlist=fpdemogpc,trimout=FALSE)

#Give input in the form of:

#One 'trim' matrix:
dp.interp(fire1,trimmedin=TRUE)

#One full length vector:
dp.interp(fire3,trimmedin=FALSE)

#A list of 'trim' matrices:
lapply(both, dp.interp, trimmedin=TRUE)

#A matrix of bound untrimmed vectors:
dp.interp(bothfat, trimmedin=FALSE)

}
\keyword{spatial}% at least one, from doc/KEYWORDS
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
