% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols_test_normality.R
\name{ols_test_normality}
\alias{ols_test_normality}
\alias{ols_test_normality.lm}
\title{Test for normality
Test for detecting violation of normality assumption.}
\usage{
ols_test_normality(model, ...)

\method{ols_test_normality}{lm}(model, ...)
}
\arguments{
\item{model}{an object of class \code{lm}.}

\item{...}{Other arguments.}
}
\value{
\code{ols_test_normality} is a list containing the
following components:

\item{kolmogorv}{kolmogorov smirnov statistic}
\item{shapiro}{shapiro wilk statistic}
\item{cramer}{cramer von mises statistic}
\item{anderson}{anderson darling statistic}
}
\description{
Test for normality
Test for detecting violation of normality assumption.
}
\examples{
model <- lm(real_gdp ~ imp + exp + usdkzt + poil, data = macroKZ)
ols_test_normality(model)

}
