\name{plotSimulationSummary} 
\alias{plotSimulationSummary} 
\title{Plots a summary of the SPD simulation test} 
\description{Plots the SPD and confidence intervals of simulated SPDs, including regions outside the CI, the model, and 200 yr rolling mean.}
\usage{plotSimulationSummary(summary, title=NULL, legend.x=NULL, legend.y=NULL)}
\arguments{
  \item{summary}{
	A list of various objects generated by \code{\link[=SPDsimulationTest]{SPDsimulationTest}} 
	}
\item{title}{
	A string title for the plot. If NULL a summary is automatically generated. If no title is preferred, use title = ''. 
	}
\item{legend.x}{
	The x coordinate for the figure legend.
	}
\item{legend.y}{
	The y coordinate for the figure legend.
	}
}
\details{
	Default NULL for legend.x and legend.y will automatically add a legend, which may not be ideally placed to avoid overlapping other components of the plot. To remove the legend, simply place well outside the boundary.
	}
\examples{
	\donttest{
	summary <- SPDsimulationTest(data=SAAD, 
		calcurve=shcal20, 
		calrange=c(2500,14000), 
		pars=-0.0001674152, 
		type='exp')
	
	plotSimulationSummary(summary)
	}
	}
