% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blank.R
\name{blankcorr}
\alias{blankcorr}
\alias{blankcorr.default}
\alias{blankcorr.timeresolved}
\alias{blankcorr.PHdata}
\title{Apply a blank correction}
\usage{
blankcorr(x, ...)

\method{blankcorr}{default}(x, ...)

\method{blankcorr}{timeresolved}(x, blanklabel = NULL, prefix = "", ...)

\method{blankcorr}{PHdata}(x, blanklabel = NULL, prefix = "", ...)
}
\arguments{
\item{x}{an object of class \code{\link{timeresolved}} or
\code{\link{PHdata}}}

\item{...}{other arguments}

\item{blanklabel}{as string denoting the prefix of the blanks}

\item{prefix}{a string to be prepended to the non-blanks}
}
\value{
an object of class \code{\link{blankcorrected}}
}
\description{
Applies a blank correction to some time-resolved mass spectrometer data
}
\examples{
samplefile <- system.file("Samples.csv",package="ArArRedux")
masses <- c("Ar37","Ar38","Ar39","Ar40","Ar36")
m <- loaddata(samplefile,masses) # samples and J-standards
blanklabel <- "EXB#"
l <- fitlogratios(blankcorr(m,blanklabel),"Ar40")
plotcorr(l)
}
