% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GrangerCausalityIndeces.R
\name{PMIME}
\alias{PMIME}
\title{PMIME Partial mutual information from mixed embedding}
\usage{
PMIME(allM, Lmax = 5, Tl = 1, nnei = 5, A = 0.03, showtxt = 1)
}
\arguments{
\item{allM}{the N x K matrix of the K time series of length N.}

\item{Lmax}{the maximum delay to search for X and Y components for the
mixed embedding vector ,default is 5.}

\item{Tl}{Tl steps ahead that the mixed embedding vector has to explain.
Note that if T>1 the future vector is of length T and contains the samples
at times t+1,..,t+T ,dafault is 1.}

\item{nnei}{number of nearest neighbors for density estimation ,default is 5}

\item{A}{the threshold for the ratio of CMI over MI of the lagged variables
for the termination criterion.}

\item{showtxt}{: if 0 or negative do not print out anything, if 1 print out
the response variable index at each run, if 2 or larger print also info for
each embedding cycle ,default is 1.}
}
\value{
\emph{RM}: A K x K matrix containing the R values computed by PMIME using
the surrogates for setting the stopping criterion.
\emph{ecC}: cell array of K components, where each component is a matrix of
size E x 5, and E is the number of embedding cycles. For each
embedding cycle the following 5 results are stored:
1. variable index, 2. lag index, 3. CMI of the selected lagged
variable w and the future response state x^F given the current
mixed embedding vector, I(x^F; w| wemb). 4. MI between x^F and
the augmented mixed embedding vector wemb w, I(x^F; w,wemb).
5. The ration of 3. and 4.: I(x^F; w| wemb)/I(x^F; w,wemb)
}
\description{
computes the measure \eqn{R_{X->Y|Z}} for all combinations of \eqn{X} and \eqn{Y} time
series from the multivariate time series given in matrix 'allM', of size
\eqn{N x K}, where \eqn{Z} contains the rest \eqn{K-2} time series.
The components of X,Y, and Z, are found from a mixed embedding aiming at
explaining \eqn{Y}. The mixed embedding is formed by using the progressive
embedding algorithm based on conditional mutual information (CMI).
CMI is estimated by the method of nearest neighbors (Kraskov's method).
The function is the same as PMIMEsig.m but defines the stopping criterion
differently, using a fixed rather than adjusted threshold. Specifically,
the algorithm terminates if the contribution of the selected lagged
variable in explaining the future response state is small enough, as
compared to a threshold 'A'. Concretely, the algorithm terminates if
\eqn{I(x^F; w| wemb) / I(x^F; w,wemb) <= A}
where \eqn{I(x^F; w| wemb)} is the CMI of the selected lagged variable w and
the future response state x^F given the current mixed embedding vector,
and \eqn{I(x^F; w,wemb)} is the MI between \eqn{x^F} and the augmented mixed
embedding vector \eqn{wemb, w}.
We experienced that in rare cases the termination condition is not
satisfied and the algorithm does not terminate. Therefore we included a
second condition for termination of the algorithm when the ratio
\eqn{I(x^F; w| wemb) / I(x^F; w,wemb)} increases in the last two embedding
cycles.
The derived \eqn{R} measure indicates the information flow of time series \eqn{X} to
time series \eqn{Y} conditioned on the rest time series in \eqn{Z}. The measure
values are stored in a \eqn{K x K} matrix 'RM' and given to the output, where
the value at position \eqn{(i,j)} indicates the effect from \eqn{i} to \eqn{j} (row to
col), and the \eqn{(i,i)} components are zero. The library RANN was used
for the nearest neighbor estimation of the mutual information
}
\seealso{
Kugiumtzis, D. "Direct-Coupling Information Measure from Nonuniform
Embedding." Physical Review E 87, no. 6 (June 25, 2013): 062918.
\doi{10.1103/PhysRevE.87.062918}
}
