% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.ampgram_model}
\alias{predict.ampgram_model}
\title{Predict antimicrobial peptides}
\usage{
\method{predict}{ampgram_model}(object, newdata, ...)
}
\arguments{
\item{object}{\code{ampgram_model} object.}

\item{newdata}{\code{list} of sequences (for example as given by
\code{\link[biogram]{read_fasta}} or \code{\link{read_txt}}).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\code{list} of objects of class \code{single_ampgram_pred}. Each object 
of this class contains analyzed sequence, values of predictions for 10-mers and 
result of the prediction for the whole peptide/protein.
}
\description{
Recognizes antimicrobial peptides using the AmpGram algorithm.
}
\details{
AmpGram requires the external package, AmpGramModel, which 
contains models necessary to perform the prediction. The model 
can be installed using \code{\link{install_AmpGramModel}}.

Predictions for each protein are stored in objects of class 
\code{single_ampgram_pred}. It consists of three elements:
\describe{
  \item{seq}{Character vector of amino acid sequence of an analyzed peptide/protein}
  \item{all_mers_pred}{Numeric vector of predictions for each 10-mer (subsequence
  of 10 amino acids) of a sequence. Prediction value indicates probability that
  a 10-mer possesses antimicrobial activity and ranges from 0 (non-AMP) to 1 
  (AMP).}
  \item{single_prot_pred}{Named numeric vector of a single prediction value for
  a whole peptide/protein. Its value corresponds to the probability that a
  peptide/protein exhibits antimicrobial activity. It assumes name \code{TRUE} 
  if probability is equal or greater than 0.5, i.e. peptide/protein is classified
  as antimicrobial (AMP), and \code{FALSE} if probability is less that 0.5,
  i.e. peptide/protein is classified as non-antimicrobial (non-AMP).}
}
}
