% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{editGenome}
\alias{editGenome}
\title{Edit genome}
\usage{
editGenome(pop, ind, chr, segSites, allele, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{ind}{a vector of individuals to edit}

\item{chr}{a vector of chromosomes to edit.
Length must match length of segSites.}

\item{segSites}{a vector of segregating sites to edit. Length must
match length of chr.}

\item{allele}{either 0 or 1 for desired allele}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns an object of \code{\link{Pop-class}}
}
\description{
Edits selected loci of selected individuals to a homozygous
state for either the 1 or 0 allele. The gv slot is recalculated to
reflect the any changes due to editing, but other slots remain the same.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=2, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)

#Change individual 1 to homozygous for the 1 allele
#at locus 1, chromosome 1
pop2 = editGenome(pop, ind=1, chr=1, segSites=1,
                  allele=1, simParam=SP)

}
