% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-Pop.R
\name{newPop}
\alias{newPop}
\title{Create new population}
\usage{
newPop(rawPop, simParam = NULL, ...)
}
\arguments{
\item{rawPop}{an object of \code{\link{MapPop-class}} or
\code{\link{NamedMapPop-class}}}

\item{simParam}{an object of \code{\link{SimParam}}}

\item{...}{additional arguments used internally}
}
\value{
Returns an object of \code{\link{Pop-class}}
}
\description{
Creates an initial \code{\link{Pop-class}} from an object of
\code{\link{MapPop-class}} or \code{\link{NamedMapPop-class}}.
The function is intended for use with output from functions such
as \code{\link{runMacs}}, \code{\link{newMapPop}}, or
\code{\link{quickHaplo}}.
}
\details{
Note that \code{newPop} takes genomes from the
  \code{rawPop} and uses them without recombination! Hence, if you
  call \code{newPop(rawPop = founderGenomes)} twice, you will get
  two sets of individuals with different id but the same genomes.
  To get genetically different sets of individuals you can subset the
  \code{rawPop} input, say first half for one set and the second half
  for the other set.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=2, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)
isPop(pop)

#Misc
pop@misc$tmp1 = rnorm(n=2)
pop@misc$tmp2 = rnorm(n=2)

#MiscPop
pop@miscPop$tmp1 = sum(pop@misc$tmp1)
pop@miscPop$tmp2 = sum(pop@misc$tmp2)
}
