% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparators.R
\name{Comparator}
\alias{Comparator}
\title{Comparator Test}
\usage{
Comparator(covar, geno, pheno, apply_int = TRUE, is_pheno_binary = FALSE)
}
\arguments{
\item{covar}{(n x p) covariate matrix.}

\item{geno}{(n x snps) genotype matrix.}

\item{pheno}{(n x 1) phenotype vector.}

\item{apply_int}{Apply rank-based inverse normal transform to the phenotype?
Default: TRUE. Ignored if phenotype is binary.}

\item{is_pheno_binary}{Is the phenotype binary? Default: FALSE.}
}
\value{
Numeric vector of p-values.
}
\description{
Runs burden, SKAT, and SKAT-O, using default settings.
}
\examples{
# Generate data.
data <- DGP(n = 1e3, snps = 1e2)

# Run the comparators.
results <- Comparator(
  geno = data$geno,
  pheno = data$pheno,
  covar = data$covar
)
}
