% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_selectWhere.R
\name{monitor_selectWhere}
\alias{monitor_selectWhere}
\title{Data-based subsetting of time series within an \emph{mts_monitor} object.}
\usage{
monitor_selectWhere(monitor, FUN)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{FUN}{A function applied to time series data that returns TRUE or FALSE.}
}
\value{
A subset of the incoming \emph{mts_monitor} object. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
Subsetting of \code{monitor} acts similarly to \code{tidyselect::where()} working on
\code{monitor$data}. The returned \emph{mts_monitor} object will contain only
those time series where \code{FUN} applied to the time series data returns \code{TRUE}.
}
\examples{
library(AirMonitor)

# Show all Camp_Fire locations
Camp_Fire$meta$locationName

# Use package US_AQI data for HAZARDOUS
name <- US_AQI$names_eng[6]
threshold <- US_AQI$breaks_PM2.5[6]

# Find HAZARDOUS locations
worst_sites <-
  Camp_Fire \%>\%
  monitor_selectWhere(
    function(x) { any(x >= threshold, na.rm = TRUE) }
  )

# Show the worst locations
worst_sites$meta$locationName

}
\seealso{
\link{monitor_select}
}
