% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_filterDatetime.R
\name{monitor_filterDatetime}
\alias{monitor_filterDatetime}
\title{Datetime filtering for \code{mts_monitor} objects}
\usage{
monitor_filterDatetime(
  monitor = NULL,
  startdate = NULL,
  enddate = NULL,
  timezone = NULL,
  unit = "sec",
  ceilingStart = FALSE,
  ceilingEnd = FALSE
)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{startdate}{Desired start datetime (ISO 8601).}

\item{enddate}{Desired end datetime (ISO 8601).}

\item{timezone}{Olson timezone used to interpret \code{startdate} and \code{enddate}.}

\item{unit}{Units used to determine time at end-of-day.}

\item{ceilingStart}{Logical specifying application of
\code{\link[lubridate]{ceiling_date}} to the \code{startdate} rather than
\code{\link[lubridate]{floor_date}}}

\item{ceilingEnd}{Logical specifying application of
\code{\link[lubridate]{ceiling_date}} to the \code{enddate} rather than
\code{\link[lubridate]{floor_date}}}
}
\value{
A subset of the given \emph{mts_monitor} object. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
Subsets a \emph{mts_monitor} object by datetime. This function
allows for sub-day filtering as opposed to \code{monitor_filterDate()} which
always filters to day-boundaries.

Datetimes can be anything that is understood by
\code{MazamaCoreUtils::parseDatetime()}. For non-\code{POSIXct} values,
the recommended format is \code{"YYYY-mm-dd HH:MM:SS"}.

If either \code{startdate} or \code{enddate} is not provided, the start/end of
the \emph{mts_monitor} time axis will be used.

Timezone determination precedence assumes that if you are passing in
\code{POSIXct} values then you know what you are doing.

\enumerate{
\item{get timezone from \code{startdate} if it is \code{POSIXct}}
\item{use passed in \code{timezone}}
\item{get timezone from \code{mts_monitor}}
}
}
\examples{
library(AirMonitor)

Camp_Fire \%>\%
  monitor_timeRange()

# Reduced time range returned in "UTC"
Camp_Fire \%>\%
  monitor_filterDatetime(
    "2018-11-15 02:00:00",
    "2018-11-22 06:00:00",
    timezone = "America/Los_Angeles"
  ) \%>\%
  monitor_timeRange()

# Reduced time range returned in "America/Los_Angeles"
Camp_Fire \%>\%
  monitor_filterDatetime(
    "2018111502",
    "2018112206",
    timezone = "America/Los_Angeles"
  ) \%>\%
  monitor_timeRange(
    timezone = "America/Los_Angeles"
  )

}
\seealso{
\link{monitor_filterDate}

\link{monitor_filterMeta}
}
