% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airnow_loadAnnual.R
\name{airnow_loadAnnual}
\alias{airnow_loadAnnual}
\title{Load annual AirNow monitoring data}
\usage{
airnow_loadAnnual(
  year = NULL,
  archiveBaseUrl = paste0("https://airfire-data-exports.s3.us-west-2.amazonaws.com/",
    "monitoring/v2"),
  archiveBaseDir = NULL,
  QC_negativeValues = c("zero", "na", "ignore"),
  parameterName = "PM2.5"
)
}
\arguments{
\item{year}{Year [YYYY].}

\item{archiveBaseUrl}{Base URL for monitoring v2 data files.}

\item{archiveBaseDir}{Local base directory for monitoring v2 data files.}

\item{QC_negativeValues}{Type of QC to apply to negative values.}

\item{parameterName}{One of the EPA AQS criteria parameter names.}
}
\value{
A \emph{mts_monitor} object with AirNow data. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
Loads pre-generated .rda files containing hourly AirNow data.

If \code{archiveDataDir} is defined, data will be loaded from this local
archive. Otherwise, data will be loaded from the monitoring data repository
maintained by the USFS AirFire team.

The files loaded by this function contain a single year's worth of data

For the most recent data in the last 10 days, use \code{airnow_loadLatest()}.

For daily updates covering the most recent 45 days, use \code{airnow_loadDaily()}.

For archival data for a specific month, use \code{airnow_loadMonthly()}.

Pre-processed AirNow exists for the following parameters:
\enumerate{
\item{PM2.5}
}
}
\examples{
\dontrun{
library(AirMonitor)

# Fail gracefully if any resources are not available
try({

# See https://en.wikipedia.org/wiki/2017_Montana_wildfires

# Daily Barplot of Montana wildfires
airnow_loadAnnual(2017) \\%>\\%
  monitor_filter(stateCode == "MT") \\%>\\%
  monitor_filterDate(20170701, 20170930, timezone = "America/Denver") \\%>\\%
  monitor_dailyStatistic() \\%>\\%
  monitor_timeseriesPlot(
    ylim = c(0, 300),
    xpd = NA,
    addAQI = TRUE,
    main = "Montana 2017 -- AirNow Daily Average PM2.5"
  )

}, silent = FALSE)
}
}
\seealso{
\code{\link{airnow_loadDaily}}

\code{\link{airnow_loadLatest}}

\code{\link{airnow_loadMonthly}}
}
