% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{Camp_Fire}
\alias{Camp_Fire}
\title{Camp Fire example dataset}
\format{
A \emph{mts_monitor} object with 360 rows and 134 columns of data.
}
\usage{
Camp_Fire
}
\description{
The \code{Camp_Fire} dataset provides a quickly loadable
version of a \emph{mts_monitor} object for practicing and code examples.
}
\details{
The 2018 Camp Fire was the deadliest and most destructive wildfire in California's
history, and the most expensive natural disaster in the world in 2018 in
terms of insured losses. The fire caused at least 85 civilian fatalities and
injured 12 civilians and five firefighters. It covered an area of 153,336
acres and destroyed more than 18,000 structures, most with the first 4 hours.
Smoke from the fire resulted in the worst air pollution ever for the
San Francisco Bay Area and Sacramento Valley.

This dataset was was generated on 2022-10-12 by running:

\preformatted{
library(AirMonitor)

Camp_Fire <-
  monitor_loadAnnual(2018) \%>\%
  monitor_filter(stateCode == 'CA') \%>\%
  monitor_filterDate(
    startdate = 20181108,
    enddate = 20181123,
    timezone = "America/Los_Angeles"
 ) \%>\%
 monitor_dropEmpty()

save(Camp_Fire, file = "data/Camp_Fire.rda")
}
}
\keyword{datasets}
