% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_function.R
\name{logistic}
\alias{logistic}
\title{Analysis: Logistic regression}
\usage{
logistic(
  trat,
  resp,
  npar = "LL.3",
  error = "SE",
  ylab = "Dependent",
  xlab = expression("Independent"),
  theme = theme_classic(),
  legend.position = "top",
  r2 = "all",
  width.bar = NA,
  scale = "none",
  textsize = 12,
  font.family = "sans"
)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{resp}{Numerical vector containing the response of the experiment.}

\item{npar}{Number of model parameters}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{Legend position (\emph{default} is c(0.3,0.8))}

\item{r2}{Coefficient of determination of the mean or all values (\emph{default} is all)}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}

\item{textsize}{Font size}

\item{font.family}{Font family (\emph{default} is sans)}
}
\value{
The function allows the automatic graph and equation construction of the logistic model, provides important statistics, such as the Akaike (AIC) and Bayesian (BIC) inference criteria, coefficient of determination (r2), square root of the mean error ( RMSE).
}
\description{
Logistic regression is a very popular analysis in agrarian sciences, such as in fruit growth curves, seed germination, etc...The logistic function performs the analysis using 3 or 4 parameters of the logistic model, being imported from the LL function .3 or LL.4 of the drc package (Ritz & Ritz, 2016).
}
\details{
The three-parameter log-logistic function with lower limit 0 is
\deqn{f(x) = 0 + \frac{d}{1+\exp(b(\log(x)-\log(e)))}}
The four-parameter log-logistic function is given by the expression
\deqn{f(x) = c + \frac{d-c}{1+\exp(b(\log(x)-\log(e)))}}
The function is symmetric about the inflection point (e).
}
\examples{
data("emerg")
with(emerg, logistic(time, resp,xlab="Time (days)",ylab="Emergence (\%)"))
with(emerg, logistic(time, resp,npar="LL.4",xlab="Time (days)",ylab="Emergence (\%)"))

}
\references{
Seber, G. A. F. and Wild, C. J (1989) Nonlinear Regression, New York: Wiley and Sons (p. 330).

Ritz, C.; Strebig, J.C.; Ritz, M.C. Package ‘drc’. Creative Commons: Mountain View, CA, USA, 2016.
}
\author{
Model imported from the drc package (Ritz et al., 2016)

Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}

Leandro Simoes Azeredo Goncalves
}
