% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{generate_age_pop_raster}
\alias{generate_age_pop_raster}
\title{Generate Age Population Raster}
\usage{
generate_age_pop_raster(
  predictor_data,
  scale_pred,
  shape_pred,
  age_range = c(0, 10),
  age_interval = 1,
  country_code,
  ignore_cache = FALSE,
  output_dir,
  n_cores = parallel::detectCores() - 2
)
}
\arguments{
\item{predictor_data}{Data frame containing population and spatial data with
columns: country, region, district, pop, web_x, web_y}

\item{scale_pred}{Matrix of scale parameters for gamma distribution
predictions}

\item{shape_pred}{Matrix of shape parameters for gamma distribution
predictions}

\item{age_range}{Numeric vector of length 2 specifying min and max ages,
default c(0,99)}

\item{age_interval}{Numeric interval size between age groups in years,
default 1}

\item{country_code}{Character ISO3 country code}

\item{ignore_cache}{Logical whether to ignore cached results, default FALSE}

\item{output_dir}{Character path to output directory}

\item{n_cores}{Integer number of cores for parallel processing, default
detectCores()-2}
}
\value{
SpatRaster object (terra package) containing multiple layers, where
   each layer represents the population proportion for an age interval.
   Layer names indicate the age range (e.g., "Age 0 to 1 years").
   The raster uses EPSG:3857 projection with 5000m resolution.
}
\description{
Creates age-stratified population raster layers from predictor data and gamma
distribution parameters. Supports parallel processing and caching of results.
The output is a multi-layer raster stack with each layer representing the
population proportion for a specific age interval.
}
\details{
The function processes age intervals sequentially, computing population
proportions using parallel processing. Results are cached as a GeoTIFF file
for future use. The output raster maintains spatial properties of the input
data and is suitable for GIS analysis and visualization.
}
\examples{
\donttest{
predictor_data <- data.frame(
 country = rep("CountryX", 100),
 region = rep("RegionA", 100),
 district = rep("District1", 100),
 pop = sample(100:1000, 100, replace = TRUE),
 web_x = runif(100, -100, 100),
 web_y = runif(100, -50, 50)
)

scale_pred <- matrix(runif(100 * 10, 1, 5), nrow = 100, ncol = 10)
shape_pred <- matrix(runif(100 * 10, 1, 5), nrow = 100, ncol = 10)

res <- generate_age_pop_raster(predictor_data,
                       scale_pred,
                       shape_pred,
                       country_code = "COD",
                       output_dir = file.path(tempdir()),
                       n_cores = 1)
}

}
