% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team_stats_per_possesion.R
\name{team_stats_per_possesion}
\alias{team_stats_per_possesion}
\title{Team stats per possesion}
\usage{
team_stats_per_possesion(df1, df2, p)
}
\arguments{
\item{df1}{Should be a Data Frame that represents the team statistics. This parameter has to be in the format provided by the team_stats() function.}

\item{df2}{Should be a Data Frame that represents the rival statistics. This parameter has to be in the format provided by the team_stats() function.}

\item{p}{Should be a  number. This parameter has to be the number of possessions to which you want to project the statistics.}
}
\value{
Data frame with statistics by game projected to the possessions entered.
}
\description{
The function allows the calculation of the statistics per game projected to P possesions.
}
\details{
The statistical projection is made from the estimation of the possessions that the team plays.
}
\examples{

df1 <- data.frame("G" = c(71), "MP" = c(17090), "FG" = c(3006),
"FGA" = c(6269),"Percentage FG" = c(0.48), "3P" = c(782),
"3PA" = c(2242), "Percentage 3P" = c(0.349),  "2P" = c(2224),
"2PA" = c(4027), "Percentage 2P" = c(0.552), "FT" = c(1260),
"FTA FG" = c(1728),  "Percentage FT" = c(0.729), "ORB" = c(757),
"DRB" = c(2490),"TRB" = c(3247),"AST" = c(1803),"STL" = c(612),
"BLK" = c(468),   "TOV" = c(1077),  "PF" = c(1471),
"PTS" = c(8054),  "+/-" = c(0))

df2 <- data.frame("G" = c(71), "MP" = c(17090), "FG" = c(2773),
"FGA" = c(6187),"Percentage FG" = c(0.448), "3P" = c(827),
"3PA" = c(2373), "Percentage 3P" = c(0.349),  "2P" = c(1946),
"2PA" = c(3814), "Percentage 2P" = c(0.510), "FT" = c(1270),
"FTA FG" = c(1626),  "Percentage FT" = c(0.781), "ORB" = c(668),
"DRB" = c(2333),"TRB" = c(3001),  "AST" = c(1662),"STL" = c(585),
"BLK" = c(263),   "TOV" = c(1130),  "PF" = c(1544),
"PTS" = c(7643),  "+/-" = c(0))

p <- 100

team_stats_per_possesion(df1,df2,p)

}
\author{
Fco Javier Cantero \email{fco.cantero@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
