% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{zih.mle}
\alias{zih.mle}
\title{Maximum likelihood estimate for Zero-Inflated or Zero-Altered discrete and continuous distributions.}
\usage{
zih.mle(x,r,p,alpha1,alpha2,n,lambda,mean,sigma,
type=c("zi","h"),dist,lowerbound=0.01,upperbound = 10000 )
}
\arguments{
\item{x}{A vector of count data which should non-negative integers for discrete cases. Real-valued random generation for continuous cases.}

\item{r}{An initial value of the number of success before which m failures are observed, where m is the element of x. Must be a positive number, but not required to be an integer.}

\item{p}{An initial value of the probability of success, should be a positive value within (0,1).}

\item{alpha1}{An initial value for the first shape parameter of beta distribution. Should be a positive number.}

\item{alpha2}{An initial value for the second shape parameter of beta distribution. Should be a positive number.}

\item{n}{An initial value of the number of trials. Must be a positive number, but not required to be an integer.}

\item{lambda}{An initial value of the rate. Must be a postive real number.}

\item{mean}{An initial value of the mean or expectation.}

\item{sigma}{An initial value of the standard deviation. Must be a positive real number.}

\item{type}{the type of distribution used to calculate the sample estimate, where 'zi' stand for zero-inflated and 'h'  stands for hurdle distributions.}

\item{dist}{The distribution used to calculate the maximum likelihood estimate. Can be one of 'poisson.zihmle', 'geometric.zihmle', 'nb.zihmle', 'nb1.zihmle', 'bb.zihmle', 'bb1.zihmle', 'bnb.zihmle', 'bnb1.zihmle', 'normal.zihmle', 'halfnorm.zihmle', 'lognorm.zimle', 'exp.zihmle', which corresponds to Zero-Inflated or Zero-Hurdle Poisson, geometric, negative binomial, negative binomial1, beta binomial, beta binomial1, beta negative binomial, beta negative binomial1, normal, log normal, half normal, and exponential distributions.}

\item{lowerbound}{A lower searching bound used in the optimization of likelihood function. Should be a small positive number. The default is 1e-2.}

\item{upperbound}{An upper searching bound used in the optimization of likelihood function. Should be a large positive number. The default is 1e4.}
}
\value{
A row vector containing the maximum likelihood estimate of the unknown parameters and the corresponding value of negative log likelihood.
}
\description{
Calculate the Maximum likelihood estimate and the corresponding negative log likelihood value for
 Zero-Inflated or Zero-Altered Poisson, geometric, negative binomial, negative binomial1,
 beta binomial, beta binomial1, beta negative binomial, beta negative binomial1,
 normal, half normal, log normal, and exponential distributions.
}
\details{
zih.mle calculate the Maximum likelihood estimate and the corresponding negative log likelihood
 of Zero-Inflated or Zero-Hurdle Poisson, geometric, negative binomial, negative binomial1,
 beta binomial, beta binomial1, beta negative binomial, beta negative binomial1,
 normal, log normal, half normal, and exponential distributions.

  If dist = poisson.zihmle, the following values are returned:
\itemize{
\item lambda: the maximum likelihood estimate of \eqn{\lambda}.
\item phi: the maximum likelihood estimate of \eqn{\phi}.
\item loglik: the value of negative log likelihood with maximum likelihood estimate plugged-in.}
If dist = geometric.zihmle, the following values are returned:
\itemize{
\item p: the maximum likelihood estimate of p.
\item phi: the maximum likelihood estimate of \eqn{\phi}.
\item loglik: the value of negative log likelihood with maximum likelihood estimate plugged-in.}
If dist = nb.zihmle, the following values are returned:
\itemize{
\item r: the maximum likelihood estimate of r.
\item p: the maximum likelihood estimate of p.
\item phi: the maximum likelihood estimate of \eqn{\phi}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = nb1.zihmle, the following values are returned:
\itemize{
\item r: the maximum likelihood estimate of rounded r (returns integer estimate).
\item p: the maximum likelihood estimate of p.
\item phi: the maximum likelihood estimate of \eqn{\phi}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = bb.zihmle, the following values are returned:
\itemize{
\item n: the maximum likelihood estimate of n.
\item alpha1: the maximum likelihood estimate of \eqn{\alpha_1}.
\item alpha2: the maximum likelihood estimate of \eqn{\alpha_2}.
\item phi: the maximum likelihood estimate of \eqn{\phi}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = bb1.zihmle, the following values are returned:
\itemize{
\item n: the maximum likelihood estimate of rounded n (returns integer estimate).
\item alpha1: the maximum likelihood estimate of \eqn{\alpha_1}.
\item alpha2: the maximum likelihood estimate of \eqn{\alpha_2}.
\item phi: the maximum likelihood estimate of \eqn{\phi}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = bnb.zihmle, the following values are returned:
\itemize{
\item r: the maximum likelihood estimate of r.
\item alpha1: the maximum likelihood estimate of \eqn{\alpha_1}.
\item alpha2: the maximum likelihood estimate of \eqn{\alpha_2}.
\item phi: the maximum likelihood estimate of \eqn{\phi}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = bnb1.zihmle, the following values are returned:
\itemize{
\item r: the maximum likelihood estimate of rounded r (returns integer estimate).
\item alpha1: the maximum likelihood estimate of \eqn{\alpha_1}.
\item alpha2: the maximum likelihood estimate of \eqn{\alpha_2}.
\item phi: the maximum likelihood estimate of \eqn{\phi}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = normal.zihmle, the following values are returned:
\itemize{
\item mean: the maximum likelihood estimate of \eqn{\mu}.
\item sigma: the maximum likelihood estimate of \eqn{\sigma}.
\item phi: the maximum likelihood estimate of \eqn{\phi}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = lognorm.zihmle, the following values are returned:
\itemize{
\item mean: the maximum likelihood estimate of \eqn{\mu}.
\item sigma: the maximum likelihood estimate of \eqn{\sigma}.
\item phi: the maximum likelihood estimate of \eqn{\phi}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = halfnorm.zihmle, the following values are returned:
\itemize{
\item sigma: the maximum likelihood estimate of \eqn{\sigma}.
\item phi: the maximum likelihood estimate of \eqn{\phi}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = exp.zihmle, the following values are returned:
\itemize{
\item lambda: the maximum likelihood estimate of \eqn{\lambda}.
\item phi: the maximum likelihood estimate of \eqn{\phi}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
}
\examples{
set.seed(007)
x1=sample.zi1(2000,phi=0.3,dist='poisson',lambda=2)
zih.mle(x1,lambda=10,dist="poisson.zihmle",type="zi")
#2.00341 0.3099267 -3164.528
x2=sample.zi1(2000,phi=0.3,dist='geometric',p=0.2)
zih.mle(x2,p=0.3,dist="geometric.zihmle",type="zi")
#0.1976744 0.2795942 -4269.259
x3=sample.zi1(2000,phi=0.3,dist='nb',r=10,p=0.3)
zih.mle(x3,r=2,p=0.2,dist="nb.zihmle",type="zi")
#10.18374 0.3033975 0.2919962 -6243.002
zih.mle(x3,r=2,p=0.2,dist="nb1.zihmle",type="zi")
#10 0.2995633 0.2919959 -6243.059
x4=sample.zi1(2000,phi=0.3,dist='bb',n=10,alpha1=2,alpha2=4)
zih.mle(x4,n=10,alpha1=3,alpha2=4,dist="bb.zihmle",type="zi")
#9.99 1.862798 3.756632 0.2643813 -3982.646
zih.mle(x4,n=10,alpha1=3,alpha2=4,dist="bb1.zihmle",type="zi")
#10 1.866493 3.76888 0.2644992 -3982.682
x5=sample.zi1(2000,phi=0.3,dist='bnb',r=5,alpha=3,alpha2=3)
zih.mle(x5,r=10,alpha1=3,alpha2=4,dist="bnb.zihmle",type="zi")
#6.936502 3.346791 2.32905 0.285682 -5088.173
zih.mle(x5,r=10,alpha1=3,alpha2=4,dist="bnb1.zihmle",type="zi")
#7 3.353377 2.313633 0.2855203 -5088.173
x6=sample.zi1(2000,phi=0.3,dist="normal",mean=10,sigma=2)
zih.mle(x6,mean=2,sigma=2,dist="normal.zihmle",type="zi")
#9.988447 2.015987 0.28 -4242.18
x7=sample.zi1(2000,phi=0.3,dist="lognormal",mean=1,sigma=4)
zih.mle(x7,mean=4,sigma=2,dist="lognorm.zihmle",type="zi")
#1.003887 3.945388 0.2985 -6544.087
x8=sample.zi1(2000,phi=0.3,dist="halfnormal",sigma=4)
zih.mle(x8,sigma=1,dist="halfnorm.zihmle",type="zi")
#1.292081 0.294 -8573.562
x9=sample.zi1(2000,phi=0.3,dist="exponential",lambda=20)
zih.mle(x9,lambda=10,dist="exp.zihmle",type="zi")
#20.1165 0.294 1614.786

set.seed(008)
y1=sample.h1(2000,phi=0.3,dist='poisson',lambda=10)
zih.mle(y1,lambda=10,dist="poisson.zihmle",type="h")
#10.11842 0.3015 -4826.566
y2=sample.h1(2000,phi=0.3,dist='geometric',p=0.3)
zih.mle(y2,p=0.2,dist="geometric.zihmle",type="h")
#0.3050884 0.2925 -4061.65
y3=sample.h1(2000,phi=0.3,dist='nb',r=10,p=0.3)
zih.mle(y3,r=2,p=0.2,dist="nb.zihmle",type="h")
#9.50756 0.2862545 0.297 -6261.479
zih.mle(y3,r=2,p=0.2,dist="nb1.zihmle",type="h")
#10 0.2966819 0.297 -6261.932
y4=sample.h1(2000,phi=0.3,dist='bb',n=10,alpha1=2,alpha2=4)
zih.mle(y4,n=10,alpha1=3,alpha2=4,dist="bb.zihmle",type="h")
#9.99 1.894627 3.851142 0.293 -4092.983
zih.mle(y4,n=10,alpha1=3,alpha2=4,dist="bb1.zihmle",type="h")
#10 1.898415 3.863768 0.293 -4093.004
y5=sample.h1(2000,phi=0.3,dist='bnb',r=5,alpha=3,alpha2=3)
zih.mle(y5,r=10,alpha1=3,alpha2=4,dist="bnb.zihmle",type="h")
#3.875685 3.026982 3.874642 0.328 -5274.091
zih.mle(y5,r=10,alpha1=3,alpha2=4,dist="bnb1.zihmle",type="h")
#4 3.028185 3.756225 0.328 -5274.092
y6=sample.h1(2000,phi=0.3,dist="normal",mean=10,sigma=2)
zih.mle(y6,mean=2,sigma=2,dist="normal.zihmle",type="h")
#10.01252 1.996997 0.29 -4201.334
y7=sample.h1(2000,phi=0.3,dist="lognormal",mean=1,sigma=4)
zih.mle(y7,mean=4,sigma=2,dist="lognorm.zihmle",type="h")
#0.9305549 3.891624 0.287 -6486.92
y8=sample.h1(2000,phi=0.3,dist="halfnormal",sigma=4)
zih.mle(y8,sigma=1,dist="halfnorm.zihmle",type="h")
#1.26807 0.3 -8863.063
y9=sample.h1(2000,phi=0.3,dist="exponential",lambda=20)
zih.mle(y9,lambda=10,dist="exp.zihmle",type="h")
#20.26938 0.2905 1645.731
}
\references{
\itemize{\item H. Aldirawi, J. Yang (2019). Model Selection and Regression Analysis for Zero-altered or Zero-inflated Data, Statistical Laboratory Technical Report, no.2019-01, University of Illinois at Chicago.}
}
