% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{FI.ZI}
\alias{FI.ZI}
\title{Inverse Fisher Information matrix and confidence intervals of the parameters for general, continuous, and discrete
zero-inflated or hurdle distributions.}
\usage{
FI.ZI(x,dist="poisson",r=NULL,p=NULL,alpha1=NULL,alpha2=NULL,
n=NULL,lambda=NULL,mean=NULL,sigma=NULL,lowerbound=0.01,upperbound=10000)
}
\arguments{
\item{x}{A vector of count data. Should be non-negative integers for discrete cases. Random generation for continuous cases.}

\item{dist}{The distribution used to calculate the inverse of fisher information and confidence interval. It can be one of poisson,geometric,nb,bb,bnb,normal,halfnormal,lognormal,exponential,zip,zigeom,zinb,zibb,zibnb,zinormal,zilognorm,zohalfnorm,ziexp,ph,geomh,nbh,bbh,bnbh which corresponds to general Poisson, geometric, negative binomial, beta binomial, beta negative binomial, normal, log normal, half normal, exponential, Zero-Inflated Poisson, Zero-Inflated geometric, Zero-Inflated negative binomial, Zero-Inflated beta binomial, Zero-Inflated beta negative binomial, Zero-Inflated/hurdle normal, Zero-Inflated/hurdle log normal, Zero-Inflated/hurdle half normal, Zero-Inflated/hurdle exponential, Zero-Hurdle Poisson, Zero-Hurdle geometric, Zero-Hurdle negative binomial, Zero-Hurdle beta binomial, and Zero-Hurdle beta negative binomial distributions, respectively.}

\item{r}{An initial value of the number of success before which m failures are observed, where m is the element of x. Must be a positive number, but not required to be an integer.}

\item{p}{An initial value of the probability of success, should be a positive value within (0,1).}

\item{alpha1}{An initial value for the first shape parameter of beta distribution. Should be a positive number.}

\item{alpha2}{An initial value for the second shape parameter of beta distribution. Should be a positive number.}

\item{n}{An initial value of the number of trials. Must be a positive number, but not required to be an integer.}

\item{lambda}{An initial value of the rate. Must be a positive real number.}

\item{mean}{An initial value of the mean or expectation.}

\item{sigma}{An initial value of the standard deviation. Must be a positive real number.}

\item{lowerbound}{A lower searching bound used in the optimization of likelihood function. Should be a small positive number. The default is 1e-2.}

\item{upperbound}{An upper searching bound used in the optimization of likelihood function. Should be a large positive number. The default is 1e4.}
}
\value{
A list containing the inverse of the fisher information matrix and the corresponding 95\% confidence interval for all the parameters in the model.
}
\description{
Computes the inverse of the fisher information matrix for Poisson, geometric, negative binomial, beta binomia,
beta negative binomial, normal, lognormal, half normal, and exponential distributions and their zero-inflated and hurdle versions along with the confidence intervals of all parameters in the model.
}
\details{
FI.ZI calculate the inverse of the fisher information matrix and the corresponding confidence interval of
the parameter of general, Zero-Inflated, and Zero-Hurdle Poisson, geometric, negative binomial, beta binomial,
beta negative binomial, normal, log normal, half normal, and exponential distributions.
Note that zero-inflated and hurdle are the same in continuous distributions.
}
\examples{
set.seed(111)
N=1000;lambda=10;
x<-stats::rpois(N,lambda=lambda)
FI.ZI(x,lambda=5,dist="poisson")
#$inversefisher
#     lambda
#[1,]  9.896

#$ConfidenceIntervals
#[1]  9.701025 10.090974
set.seed(111)
N=1000;lambda=10;phi=0.4;
x1<-sample.h1(N,lambda=lambda,phi=phi,dist="poisson")
FI.ZI(x1,lambda=4,dist="ph")
#$inversefisher
#       [,1]     [,2]
#[1,] 0.237679  0.00000
#[2,] 0.000000 16.12686

#$ConfidenceIntervals
#              [,1]       [,2]
#CI of Phi    0.3587835  0.4192165
#CI of lambda 9.6000082 10.0978060
set.seed(289)
N=2000;mean=10;sigma=2;phi=0.4;
x<-sample.zi1(N,phi=phi,mean=mean,sigma=sigma,dist="lognormal")
FI.ZI(x, mean=1,sigma=1, dist="zilognorm")
# $inversefisher
#        [,1]     [,2]     [,3]
#[1,] 0.6313214 0.000000 0.000000
#[2,] 0.0000000 6.698431 0.000000
#[3,] 0.0000000 0.000000 3.349215

#$ConfidenceIntervals
#              [,1]       [,2]
#CI of phi   0.3521776  0.4218224
#CI of mean  9.8860358 10.1128915
#CI of sigma 1.9461552  2.1065664
}
\references{
\itemize{\item Aldirawi H, Yang J (2022). “Modeling Sparse Data Using MLE with Applications to Micro-
biome Data.” Journal of Statistical Theory and Practice, 16(1), 1–16.}
}
