/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.proxies;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxyFactory;
import com.amazonaws.services.kinesis.clientlibrary.proxies.KinesisProxy;

public class KinesisProxyFactory
implements IKinesisProxyFactory {
    private final AWSCredentialsProvider credentialProvider;
    private static String defaultServiceName = "kinesis";
    private static String defaultRegionId = "us-east-1";
    private static final long DEFAULT_DESCRIBE_STREAM_BACKOFF_MILLIS = 1000L;
    private static final int DEFAULT_DESCRIBE_STREAM_RETRY_TIMES = 50;
    private final AmazonKinesis kinesisClient;
    private final long describeStreamBackoffTimeInMillis;
    private final int maxDescribeStreamRetryAttempts;

    public KinesisProxyFactory(AWSCredentialsProvider credentialProvider, String endpoint) {
        this(credentialProvider, new ClientConfiguration(), endpoint, defaultServiceName, defaultRegionId, 1000L, 50);
    }

    public KinesisProxyFactory(AWSCredentialsProvider credentialProvider, ClientConfiguration clientConfig, String endpoint) {
        this(credentialProvider, clientConfig, endpoint, defaultServiceName, defaultRegionId, 1000L, 50);
    }

    public KinesisProxyFactory(AWSCredentialsProvider credentialProvider, AmazonKinesis client) {
        this(credentialProvider, client, 1000L, 50);
    }

    KinesisProxyFactory(AWSCredentialsProvider credentialProvider, ClientConfiguration clientConfig, String endpoint, String serviceName, String regionId, long describeStreamBackoffTimeInMillis, int maxDescribeStreamRetryAttempts) {
        this(credentialProvider, (AmazonKinesis)KinesisProxyFactory.buildClientSettingEndpoint(credentialProvider, clientConfig, endpoint, serviceName, regionId), describeStreamBackoffTimeInMillis, maxDescribeStreamRetryAttempts);
    }

    KinesisProxyFactory(AWSCredentialsProvider credentialProvider, AmazonKinesis client, long describeStreamBackoffTimeInMillis, int maxDescribeStreamRetryAttempts) {
        this.kinesisClient = client;
        this.credentialProvider = credentialProvider;
        this.describeStreamBackoffTimeInMillis = describeStreamBackoffTimeInMillis;
        this.maxDescribeStreamRetryAttempts = maxDescribeStreamRetryAttempts;
    }

    @Override
    public IKinesisProxy getProxy(String streamName) {
        return new KinesisProxy(streamName, this.credentialProvider, this.kinesisClient, this.describeStreamBackoffTimeInMillis, this.maxDescribeStreamRetryAttempts);
    }

    private static AmazonKinesisClient buildClientSettingEndpoint(AWSCredentialsProvider credentialProvider, ClientConfiguration clientConfig, String endpoint, String serviceName, String regionId) {
        AmazonKinesisClient client = new AmazonKinesisClient(credentialProvider, clientConfig);
        client.setEndpoint(endpoint);
        client.setSignerRegionOverride(regionId);
        return client;
    }
}

