% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mut.R
\name{mut}
\alias{mut}
\title{Performing mutation\cr}
\usage{
mut(
  parents,
  heredity = "Strong",
  nmain.p,
  r1,
  r2,
  interaction.ind = NULL,
  interonly = "No",
  aprob = 0.9,
  dprob = 0.9,
  aprobm = 0.1,
  aprobi = 0.9,
  dprobm = 0.9,
  dprobi = 0.1
)
}
\arguments{
\item{parents}{A numeric matrix of dimension \code{q} by \code{r1+r2},
obtained from \code{initial} or previous generation where each row corresponding
a fitted model and each column representing the predictor index in the fitted model.}

\item{heredity}{Whether to enforce Strong, Weak, or No heredity. Default is "Strong".}

\item{nmain.p}{A numeric value that represents the total number of main effects
in \code{X}.}

\item{r1}{A numeric value indicating the maximum number of main effects.}

\item{r2}{A numeric value indicating the maximum number of interaction effects.}

\item{interaction.ind}{A two-column numeric matrix containing all possible
two-way interaction effects. It must be generated outside of this function
using \code{t(utils::combn())}. See Example section for details.}

\item{interonly}{Whether or not to consider fitted models with only two-way
interaction effects. A “Yes" or "No" logical vector. Default is "No".}

\item{aprob}{A numeric value between 0 and 1, defined by users.
The addition probability during mutation. Default is 0.9.}

\item{dprob}{A numeric value between 0 and 1, defined by users.
The deletion probability during mutation. Default is 0.9.}

\item{aprobm}{A numeric value between 0 and 1, defined by users.
The main effect addition probability during addition. Default is 0.1.}

\item{aprobi}{A numeric value between 0 and 1, defined by users.
The interaction effect addition probability during addition. Default is 0.9.}

\item{dprobm}{A numeric value between 0 and 1, defined by users.
The main effect deletion probability during deletion. Default is 0.9.}

\item{dprobi}{A numeric value between 0 and 1, defined by users.
The interaction effect deletion probability during deletion. Default is 0.1.}
}
\value{
A numeric matrix \code{single.child.mutated} is returned. Each row representing
a fitted model, and each column corresponding to the predictor index in the fitted model.
Duplicated models are allowed.
}
\description{
This function performs mutation which only stores all fitted models without
making any comparison. The selected indices in each fitted model will be
automatically re-ordered so that main effects comes first, followed by
two-way interaction effects, and zero reservation spaces.
}
\examples{
# Under Strong heredity, interonly = "No"
set.seed(0)
nmain.p <- 4
interaction.ind <- t(combn(4,2))
X <- matrix(rnorm(50*4,1,0.1), 50, 4)
epl <- rnorm(50,0,0.01)
y <- 1+X[,1]+X[,2]+X[,1]*X[,2]+epl
p1 <- initial(X, y, nmain.p = 4, r1 = 3, r2 = 3,
    interaction.ind = interaction.ind, q = 5)
m1 <- mut(p1, nmain.p = 4, r1 = 3, r2 = 3,
    interaction.ind =interaction.ind)
# Under Strong heredity, interonly = "Yes"
m2 <- mut(p1, heredity = "No", nmain.p = 4, r1 = 3, r2 = 3,
    interaction.ind =interaction.ind, interonly = "Yes")
}
\seealso{
\code{\link{initial}}.
}
